/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import local.ytk.skillsmod.command.SkillCommand;
import local.ytk.skillsmod.network.SkillListSyncPayload;
import local.ytk.skillsmod.network.SkillUpdatePayload;
import local.ytk.skillsmod.skills.SkillData;
import local.ytk.skillsmod.skills.SkillInstance;
import local.ytk.skillsmod.skills.SkillList;
import local.ytk.skillsmod.skills.SkillManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3264;
import net.minecraft.server.MinecraftServer;

public class SkillsMod
implements ModInitializer {
    public static final String MOD_ID = "skills";
    public static final class_2960 MAX_HEALTH_SKILL_ID = SkillsMod.id("max_health");
    final SkillManager skillManager = SkillManager.INSTANCE;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this.skillManager);
        CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> SkillCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayConnectionEvents.JOIN.register(SkillsMod::playerJoin);
        ServerLivingEntityEvents.AFTER_DEATH.register(SkillsMod::afterDeath);
        ServerPlayerEvents.AFTER_RESPAWN.register(SkillsMod::playerRespawn);
        PayloadTypeRegistry.playS2C().register(SkillListSyncPayload.PAYLOAD_ID, SkillListSyncPayload.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(SkillUpdatePayload.PAYLOAD_ID, SkillUpdatePayload.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SkillUpdatePayload.PAYLOAD_ID, this::handleSkillUpdate);
    }

    private static void playerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        SkillsMod.syncSkills(handler.field_14140, handler.field_14140, SkillManager.getSkills((class_1657)handler.field_14140));
    }

    private static void afterDeath(class_1309 entity, class_1282 damageSource) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            SkillsMod.syncSkills(player.method_5682(), player, SkillManager.getSkills((class_1657)player));
        }
    }

    private static void playerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        SkillsMod.syncSkills(oldPlayer.method_5682(), oldPlayer, SkillManager.getSkills((class_1657)oldPlayer));
        SkillsMod.syncSkills(newPlayer.method_5682(), newPlayer, SkillManager.getSkills((class_1657)newPlayer));
        SkillData.PlayerSkillData playerState = SkillData.getPlayerState((class_1657)newPlayer);
        SkillInstance skillInstance = playerState.skillList().getSkillInstance(MAX_HEALTH_SKILL_ID);
        if (skillInstance != null) {
            newPlayer.method_6025((float)skillInstance.getLevel());
        }
    }

    private void handleSkillUpdate(SkillUpdatePayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        SkillData.PlayerSkillData playerState = SkillData.getPlayerState((class_1657)player);
        SkillList skillList = playerState.skillList();
        if (!payload.isEmpty()) {
            int addXp = payload.addXp();
            int addLevels = payload.addLevels();
            if (addLevels <= 1) {
                SkillInstance newSkillInstance = payload.skillInstance();
                SkillInstance playerSkillInstance = skillList.get(newSkillInstance.skill);
                int xpToNextLevel = playerSkillInstance.getXpToNextLevel();
                if (player.field_7495 >= xpToNextLevel + addXp) {
                    if (addLevels > 0) {
                        playerSkillInstance.spendXp(xpToNextLevel, (class_1657)player);
                    }
                    if (addXp > 0) {
                        playerSkillInstance.spendXp(addXp, (class_1657)player);
                    }
                    if (playerSkillInstance.skill.id.equals((Object)MAX_HEALTH_SKILL_ID)) {
                        player.method_6025((float)addLevels);
                    }
                }
            }
        }
        SkillsMod.syncSkills(player.method_5682(), player, skillList);
    }

    public static void syncSkills(MinecraftServer server, class_3222 target, SkillList skillList) {
        SkillManager.updateSkills((class_1657)target, skillList);
        server.method_3760().method_14581((class_2596)SkillListSyncPayload.createPacket((class_1657)target, skillList));
    }

    public static void syncSkills(class_3222 player, class_3222 target, SkillList skillList) {
        SkillManager.updateSkills((class_1657)target, skillList);
        player.field_13987.method_14364((class_2596)SkillListSyncPayload.createPacket((class_1657)target, skillList));
    }
}

