/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import local.ytk.skillsmod.SkillsMod;
import local.ytk.skillsmod.skills.Skill;
import local.ytk.skillsmod.skills.SkillInstance;
import local.ytk.skillsmod.skills.SkillList;
import local.ytk.skillsmod.skills.SkillManager;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class SkillCommand {
    public static final int SUCCESS = 1;
    public static final int FAILURE = 0;
    public static final SkillSuggestionProvider SKILLS_SUGGESTIONS = new SkillSuggestionProvider();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skill").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(SkillCommand::listAllSkills)).then(class_2170.method_9247((String)"all").executes(SkillCommand::listAllSkills))).then(class_2170.method_9247((String)"for").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkillCommand::listSkillsForPlayer))))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkillCommand::listSkillsForPlayer)).then(class_2170.method_9244((String)"skill", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)SKILLS_SUGGESTIONS).executes(SkillCommand::getSkill))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"skill", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)SKILLS_SUGGESTIONS).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"levels", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::setSkillLevel)).then(class_2170.method_9244((String)"xp", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::setSkill)))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"levels", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::setSkillLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"xp", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::setSkillXp))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"skill", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)SKILLS_SUGGESTIONS).then(class_2170.method_9244((String)"levels", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::addSkillLevel))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"levels", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::addSkillLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"xp", (ArgumentType)IntegerArgumentType.integer()).executes(SkillCommand::addSkillXp)))))));
    }

    static int listAllSkills(CommandContext<class_2168> context) {
        Collection<Skill> skills = SkillManager.getSkills();
        class_5250 message = skills.isEmpty() ? class_2561.method_43471((String)"commands.skill.none") : (class_2561)skills.stream().map(skill -> class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"commands.skill.item.all", (Object[])new Object[]{class_2561.method_43471((String)skill.key), class_2561.method_43470((String)String.valueOf(skill.maxLevel))}))).reduce(class_2561.method_43471((String)"commands.skill.all"), class_5250::method_10852);
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int listSkillsForPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        class_5250 items = skillList.isEmpty() ? class_2561.method_43469((String)"commands.skill.player.none", (Object[])new Object[]{player.method_5476()}) : (class_2561)skillList.skills().values().stream().map(s -> class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"commands.skill.item.player", (Object[])new Object[]{class_2561.method_43471((String)s.skill.key), class_2561.method_43470((String)String.valueOf(s.level)), class_2561.method_43470((String)String.valueOf(s.xp))}))).reduce(class_2561.method_43473(), class_5250::method_10852);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player", (Object[])new Object[]{player.method_5476()}).method_10852((class_2561)items);
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int getSkill(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.value", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int getSkillLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        class_5250 message = class_2561.method_43469((String)"commands.skill.item.player.level", (Object[])new Object[]{class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int getSkillXp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        class_5250 message = class_2561.method_43469((String)"commands.skill.item.player.level_xp", (Object[])new Object[]{class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int setSkill(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        int level = IntegerArgumentType.getInteger(context, (String)"levels");
        int xp = IntegerArgumentType.getInteger(context, (String)"xp");
        skill.setLevel(level);
        skill.setXp(xp);
        SkillManager.updateSkills((class_1657)player, skillList);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.set", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int setSkillLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        int level = IntegerArgumentType.getInteger(context, (String)"levels");
        skill.setLevel(level);
        SkillManager.updateSkills((class_1657)player, skillList);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.set", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int setSkillXp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        int xp = IntegerArgumentType.getInteger(context, (String)"xp");
        skill.setXp(xp);
        SkillManager.updateSkills((class_1657)player, skillList);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.set", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int addSkillLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        int levels = IntegerArgumentType.getInteger(context, (String)"levels");
        skill.addLevels(levels, (class_1657)player);
        SkillManager.updateSkills((class_1657)player, skillList);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.set", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    static int addSkillXp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 id;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        SkillList skillList = SkillManager.getSkills((class_1657)player);
        SkillInstance skill = skillList.getSkillInstance(id = class_2232.method_9443(context, (String)"skill"));
        if (skill == null) {
            if (!SkillManager.hasSkill(id)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.skill.player.notfound", (Object[])new Object[]{player.method_5476(), id.toString()}));
                return 0;
            }
            skill = SkillManager.createInstance(id);
        }
        int xp = IntegerArgumentType.getInteger(context, (String)"xp");
        skill.addXp(xp, (class_1657)player);
        SkillsMod.syncSkills(((class_2168)context.getSource()).method_9211(), player, skillList);
        class_5250 message = class_2561.method_43469((String)"commands.skill.player.set", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)skill.skill.key), class_2561.method_43470((String)String.valueOf(skill.level)), class_2561.method_43470((String)String.valueOf(skill.xp))});
        ((class_2168)context.getSource()).method_45068((class_2561)message);
        return 1;
    }

    public static class SkillSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            SkillManager.getSkills().stream().filter(skill -> skill.id.toString().endsWith(builder.getRemaining())).forEach(skill -> builder.suggest(skill.id.toString()));
            return builder.buildFuture();
        }
    }
}

