/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.skills;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import local.ytk.skillsmod.skills.LinkedEntityAttributeModifier;
import local.ytk.skillsmod.skills.SkillInstance;
import local.ytk.skillsmod.skills.SkillManager;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Skill
implements Comparable<Skill> {
    public static final IntStream DEFAULT_XP_REQUIRED = IntStream.range(0, 100).map(i -> 100 * i);
    public static final Codec<Skill> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(Skill::id), (App)Codec.INT.fieldOf("base").forGetter(Skill::base), (App)Codec.INT.fieldOf("max_level").forGetter(Skill::maxLevel), (App)Codec.either(Level.CODEC, (Codec)Level.CODEC.listOf()).fieldOf("levels").forGetter(s -> Either.right(s.levels())), (App)Codec.BOOL.optionalFieldOf("stack_lower_levels", (Object)false).forGetter(Skill::stackLowerLevels), (App)Codec.INT_STREAM.optionalFieldOf("xp_required").xmap(s -> s.map(IntStream::toArray).map(IntList::of).orElse(IntList.of()), l -> Optional.ofNullable(l).map(IntCollection::intStream)).forGetter(Skill::xpRequired), (App)LinkedEntityAttributeModifier.CODEC.listOf().optionalFieldOf("bonus_modifiers", List.of()).forGetter(Skill::bonusModifiers), (App)class_1293.field_48821.listOf().optionalFieldOf("bonus_effects", List.of()).forGetter(Skill::bonusEffects), (App)class_2960.field_25139.optionalFieldOf("icon", (Object)class_2960.method_60656((String)"empty")).forGetter(Skill::iconId)).apply((Applicative)instance, Skill::new));
    public static final Codec<Skill> ID_CODEC = class_2960.field_25139.xmap(SkillManager::getSkill, Skill::id);
    public final class_2960 id;
    public final String key;
    public final int base;
    public final int maxLevel;
    public final List<Level> levels;
    @Nullable
    public final Level allLevels;
    public final boolean stackLowerLevels;
    public final IntList xpRequired;
    public final List<LinkedEntityAttributeModifier> bonusModifiers;
    public final List<class_1293> bonusEffects;
    @Nullable
    public final class_2960 iconId;

    public Skill(class_2960 id, int base, int maxLevel, Either<Level, List<Level>> levels, boolean stackLowerLevels, @Nullable IntList xpRequired, List<LinkedEntityAttributeModifier> bonusModifiers, List<class_1293> bonusEffects, @Nullable class_2960 iconId) {
        this.id = id;
        this.key = id.method_42093("skill");
        this.base = base;
        this.maxLevel = maxLevel;
        this.bonusModifiers = bonusModifiers;
        this.bonusEffects = bonusEffects;
        this.iconId = iconId;
        if (levels.left().isPresent()) {
            Level level = (Level)levels.left().get();
            this.levels = Collections.nCopies(maxLevel, level);
            this.allLevels = level;
            this.xpRequired = xpRequired != null && !xpRequired.isEmpty() ? xpRequired : IntList.of((int[])IntStream.range(0, maxLevel).map(i -> level.xpRequired * (i + 1)).toArray());
            this.stackLowerLevels = true;
        } else if (levels.right().isPresent()) {
            this.levels = (List)levels.right().get();
            this.allLevels = null;
            this.xpRequired = null;
            this.stackLowerLevels = stackLowerLevels;
        } else {
            throw new IllegalArgumentException("Either a single level or a list of levels must be provided");
        }
    }

    public Skill(class_2960 id, int base, int maxLevel, Level allLevels, IntList xpRequired, @Nullable class_2960 iconId) {
        this.id = id;
        this.key = id.method_42093("skill");
        this.base = base;
        this.maxLevel = maxLevel;
        this.levels = Collections.nCopies(maxLevel, allLevels);
        this.allLevels = allLevels;
        this.stackLowerLevels = true;
        this.xpRequired = xpRequired;
        this.bonusModifiers = allLevels.modifiers;
        this.bonusEffects = allLevels.effects;
        this.iconId = iconId;
    }

    /*
     * Exception decompiling
     */
    public static Stream<LinkedEntityAttributeModifier> mergeSimilar(Map.Entry<class_1320, Collection<LinkedEntityAttributeModifier>> e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=2,264
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SkillInstance createInstance() {
        return new SkillInstance(this);
    }

    public SkillInstance createInstance(int level, int xp) {
        return new SkillInstance(this, level, xp);
    }

    public class_2960 id() {
        return this.id;
    }

    public int base() {
        return this.base;
    }

    public int maxLevel() {
        return this.maxLevel;
    }

    public List<Level> levels() {
        return this.levels;
    }

    public boolean stackLowerLevels() {
        return this.stackLowerLevels;
    }

    public List<LinkedEntityAttributeModifier> bonusModifiers() {
        return this.bonusModifiers;
    }

    public List<class_1293> bonusEffects() {
        return this.bonusEffects;
    }

    public IntList xpRequired() {
        return this.xpRequired;
    }

    @Nullable
    public class_2960 iconId() {
        return this.iconId;
    }

    public int xpRequired(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level must be at least 1");
        }
        if (level == 0) {
            return 0;
        }
        if (level > this.maxLevel) {
            level = this.maxLevel;
        }
        if (this.xpRequired == null) {
            if (this.allLevels != null) {
                return this.allLevels.xpRequired * level;
            }
            return this.levels.get((int)(level - 1)).xpRequired;
        }
        return this.xpRequired.getInt(level - 1);
    }

    public List<LinkedEntityAttributeModifier> getRawModifiers(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level must be at least 1");
        }
        if (level == 0) {
            return List.of();
        }
        if (level > this.maxLevel) {
            level = this.maxLevel;
        }
        if (this.allLevels != null) {
            return Collections.nCopies(level, this.allLevels).stream().flatMap(l -> l.modifiers.stream()).toList();
        }
        if (this.stackLowerLevels) {
            return this.levels.subList(0, level).stream().flatMap(l -> l.modifiers.stream()).toList();
        }
        return this.levels.get((int)(level - 1)).modifiers;
    }

    public List<LinkedEntityAttributeModifier> getModifiers(int level) {
        List<LinkedEntityAttributeModifier> modifiers;
        if (level < 0) {
            throw new IllegalArgumentException("Level must be at least 0");
        }
        if (level == 0) {
            return List.of();
        }
        if (this.allLevels != null) {
            modifiers = this.allLevels.modifiers.stream().map(m -> new LinkedEntityAttributeModifier(m.attribute(), m.id(), m.value() * (double)level, m.operation())).collect(Collectors.toList());
        } else if (this.stackLowerLevels) {
            HashMultimap map = HashMultimap.create();
            this.levels.subList(0, Math.min(level, this.maxLevel)).forEach(arg_0 -> Skill.lambda$getModifiers$10((Multimap)map, arg_0));
            modifiers = map.asMap().entrySet().stream().flatMap(Skill::mergeSimilar).collect(Collectors.toList());
        } else {
            modifiers = new ArrayList<LinkedEntityAttributeModifier>(this.levels.get((int)(Math.min((int)level, (int)this.maxLevel) - 1)).modifiers);
        }
        if (level >= this.maxLevel) {
            modifiers.addAll(this.bonusModifiers);
        }
        return modifiers;
    }

    public List<class_1293> getEffects(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level must be at least 1");
        }
        if (level == 0) {
            return List.of();
        }
        List<Object> effects = this.allLevels != null ? this.allLevels.effects.stream().map(e -> new class_1293(e.method_5579(), e.method_5584(), e.method_5578() + level - 1, e.method_5591(), e.method_5581())).toList() : (this.stackLowerLevels ? this.levels.subList(0, Math.min(level, this.maxLevel)).stream().flatMap(l -> l.effects.stream()).toList() : this.levels.get((int)(Math.min((int)level, (int)this.maxLevel) - 1)).effects);
        if (level >= this.maxLevel) {
            effects.addAll(this.bonusEffects);
        }
        return effects;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Skill other = (Skill)obj;
        return Objects.equals(this.id, other.id) && this.base == other.base && this.maxLevel == other.maxLevel && Objects.equals(this.levels, other.levels) && this.stackLowerLevels == other.stackLowerLevels;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.base, this.maxLevel, this.levels, this.stackLowerLevels);
    }

    public String toString() {
        return "Skill[id=" + String.valueOf(this.id) + ", base=" + this.base + ", maxLevel=" + this.maxLevel + ", levels=" + String.valueOf(this.levels) + ", stackLowerLevels=" + this.stackLowerLevels + "]";
    }

    @Override
    public int compareTo(@NotNull Skill other) {
        if (other == this) {
            return 0;
        }
        return this.id.method_12833(other.id);
    }

    private static /* synthetic */ void lambda$getModifiers$10(Multimap map, Level l) {
        l.modifiers.forEach(m -> map.put((Object)m.attribute(), m));
    }

    public record Level(int xpRequired, List<LinkedEntityAttributeModifier> modifiers, List<class_1293> effects) {
        public static final Codec<Level> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("xp").forGetter(Level::xpRequired), (App)LinkedEntityAttributeModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(Level::modifiers), (App)class_1293.field_48821.listOf().optionalFieldOf("effects", List.of()).forGetter(Level::effects)).apply((Applicative)instance, Level::new));

        @Override
        public String toString() {
            return this.xpRequired + ": " + String.valueOf(this.modifiers) + "; " + String.valueOf(this.effects);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Level other = (Level)obj;
            return this.xpRequired == other.xpRequired && Objects.equals(this.modifiers, other.modifiers);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.xpRequired, this.modifiers, this.effects);
        }
    }
}

