/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.skills;

import com.mojang.serialization.Codec;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import local.ytk.skillsmod.skills.SkillList;
import local.ytk.skillsmod.skills.SkillManager;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class SkillData
extends class_18 {
    public static final Codec<SkillData> CODEC = class_2487.field_25128.xmap(SkillData::fromNbt, SkillData::toNbt);
    private static final class_10741<SkillData> TYPE = new class_10741("skills", SkillData::new, CODEC, null);
    public final HashMap<UUID, PlayerSkillData> players = new HashMap();

    public SkillList getPlayerSkills(UUID uuid) {
        return this.players.computeIfAbsent((UUID)uuid, (Function<UUID, PlayerSkillData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.util.UUID ), (Ljava/util/UUID;)Llocal/ytk/skillsmod/skills/SkillData$PlayerSkillData;)()).skillList;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 skillTag = new class_2487();
        for (UUID uuid : this.players.keySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_10566("skills", (class_2520)this.getPlayerSkills(uuid).toNbt());
            skillTag.method_10566(uuid == null ? "PLAYER" : uuid.toString(), (class_2520)playerTag);
        }
        nbt.method_10566("players", (class_2520)skillTag);
        return nbt;
    }

    public class_2487 toNbt() {
        return this.writeNbt(new class_2487());
    }

    public static SkillData fromNbt(class_2487 nbt) {
        SkillData state = new SkillData();
        class_2487 skillTag = nbt.method_10562("players").orElseGet(class_2487::new);
        for (String key : skillTag.method_10541()) {
            UUID uuid = key.equals("PLAYER") ? null : UUID.fromString(key);
            class_2487 playerTag = nbt.method_10562(key).orElseGet(class_2487::new);
            PlayerSkillData playerState = new PlayerSkillData(SkillList.fromNbt(playerTag.method_10562("skills").orElseGet(class_2487::new)));
            state.players.put(uuid, playerState);
        }
        return state;
    }

    public static SkillData getServerState(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        assert (world != null);
        SkillData state = (SkillData)world.method_17983().method_17924(TYPE);
        state.method_80();
        return state;
    }

    public static PlayerSkillData getPlayerState(class_1657 player) {
        assert (player != null);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return new PlayerSkillData(player.method_5667());
        }
        SkillData state = SkillData.getServerState(server);
        PlayerSkillData playerState = state.players.computeIfAbsent(player.method_5667(), uuid -> state.players.computeIfAbsent(null, PlayerSkillData::new));
        if (server.method_3724()) {
            state.players.put(null, playerState);
        }
        return playerState;
    }

    public PlayerSkillData getLocalPlayerState(class_1657 player) {
        assert (player != null);
        return this.players.computeIfAbsent(player.method_5667(), uuid -> this.players.computeIfAbsent(null, PlayerSkillData::new));
    }

    public record PlayerSkillData(SkillList skillList) {
        public PlayerSkillData(UUID uuid) {
            this(SkillManager.createEmptySkillList());
        }
    }
}

