/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.skills;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import local.ytk.skillsmod.skills.Skill;
import local.ytk.skillsmod.skills.SkillManager;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SkillInstance {
    public static final Codec<SkillInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Skill.ID_CODEC.fieldOf("skill").forGetter(SkillInstance::getSkill), (App)Codec.INT.fieldOf("level").forGetter(SkillInstance::getLevel), (App)Codec.INT.fieldOf("xp").forGetter(SkillInstance::getXp)).apply((Applicative)instance, SkillInstance::new));
    public static final class_9139<class_9129, SkillInstance> PACKET_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, SkillInstance::getId, (class_9139)class_9135.field_49675, SkillInstance::getLevel, (class_9139)class_9135.field_49675, SkillInstance::getXp, SkillManager::createInstance);
    public Skill skill;
    public int level;
    public int xp;

    public SkillInstance(Skill skill, int level, int xp) {
        this.skill = skill;
        this.level = level;
        this.xp = xp;
    }

    public SkillInstance(Skill skill) {
        this(skill, 0, 0);
    }

    public Skill getSkill() {
        return this.skill;
    }

    class_2960 getId() {
        return this.skill.id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getXp() {
        return this.xp;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public void spendXp(int xp, class_1657 player) {
        this.addXp(xp, player);
        player.field_7510 -= (float)xp / (float)player.method_7349();
        player.field_7495 = class_3532.method_15340((int)(player.field_7495 - xp), (int)0, (int)Integer.MAX_VALUE);
        while (player.field_7510 < 0.0f) {
            float f = player.field_7510 * (float)player.method_7349();
            if (player.field_7520 > 0) {
                player.method_7316(-1);
                player.field_7510 = 1.0f + f / (float)player.method_7349();
                continue;
            }
            player.method_7316(-1);
            player.field_7510 = 0.0f;
        }
    }

    public void addXp(int xp, @Nullable class_1657 player) {
        this.xp += xp;
        while (this.xp >= this.skill.levels.get(this.level).xpRequired()) {
            MinecraftServer server;
            this.xp -= this.skill.levels.get(this.level).xpRequired();
            ++this.level;
            MinecraftServer minecraftServer = server = player != null ? player.method_5682() : null;
            if (this.level == 1) {
                if (server == null) continue;
                server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.unlock", (Object[])new Object[]{player.method_5477(), this.skill.id.toString()}));
                continue;
            }
            if (this.level >= this.skill.maxLevel()) {
                this.level = this.skill.maxLevel();
                if (server == null) break;
                server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.max", (Object[])new Object[]{player.method_5477(), this.skill.id.toString(), this.level}));
                break;
            }
            if (server == null) continue;
            server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.levelup", (Object[])new Object[]{player.method_5477(), this.skill.id.toString(), this.level}));
        }
    }

    public void addLevels(int levels, @Nullable class_1657 player) {
        MinecraftServer server;
        if (this.level >= this.skill.maxLevel()) {
            return;
        }
        this.level += levels;
        MinecraftServer minecraftServer = server = player != null ? player.method_5682() : null;
        if (this.level == 1) {
            if (server != null) {
                server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.unlock", (Object[])new Object[]{player.method_5477(), this.skill.id.toString()}));
            }
        } else if (this.level >= this.skill.maxLevel()) {
            this.level = this.skill.maxLevel();
            if (server != null) {
                server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.max", (Object[])new Object[]{player.method_5477(), this.skill.id.toString(), this.level}));
            }
        } else if (server != null) {
            server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.skill.levelup", (Object[])new Object[]{player.method_5477(), this.skill.id.toString(), this.level}));
        }
    }

    public int getXpToNextLevel() {
        if (this.level >= this.skill.maxLevel()) {
            return 0;
        }
        return this.skill.levels.get(this.level).xpRequired() - this.xp;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        if (this.skill != null) {
            nbt.method_10582("skill", this.skill.id.toString());
        }
        nbt.method_10569("level", this.level);
        nbt.method_10569("xp", this.xp);
        return nbt;
    }

    public static SkillInstance fromNbt(class_2487 nbt) {
        class_2960 id = nbt.method_10558("skill").map(class_2960::method_60654).orElse(null);
        Skill skill = SkillManager.getSkill(id);
        int level = nbt.method_10550("level").orElse(0);
        int xp = nbt.method_10550("xp").orElse(0);
        return new SkillInstance(skill, level, xp);
    }

    public Map.Entry<Skill, SkillInstance> toEntry() {
        return Map.entry(this.skill, this);
    }

    public String toString() {
        return "SkillInstance[skill=" + String.valueOf(this.skill.id) + ", level=" + this.level + ", xp=" + this.xp + "]";
    }
}

