/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.skills;

import com.mojang.serialization.Codec;
import java.util.Map;
import local.ytk.skillsmod.skills.Skill;
import local.ytk.skillsmod.skills.SkillInstance;
import local.ytk.skillsmod.skills.SkillManager;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public record SkillList(Map<Skill, SkillInstance> skills) {
    public static final Codec<SkillList> CODEC = class_2487.field_25128.xmap(SkillList::fromNbt, SkillList::toNbt);

    public SkillInstance getSkillInstance(class_2960 id) {
        Skill skill = SkillManager.getSkill(id);
        if (skill == null) {
            return null;
        }
        return this.get(skill);
    }

    public static SkillList fromNbt(class_2487 nbt) {
        SkillList skillList = SkillManager.createEmptySkillList();
        if (nbt == null) {
            return skillList;
        }
        for (String key : nbt.method_10541()) {
            Skill skill = SkillManager.getSkill(class_2960.method_60654((String)key));
            if (skill == null) continue;
            SkillInstance skillInstance = skillList.get(skill);
            class_2487 skillNbt = nbt.method_68568(key);
            skillInstance.setLevel(skillNbt.method_68083("level", 0));
            skillInstance.setXp(skillNbt.method_68083("xp", 0));
        }
        return skillList;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        for (Map.Entry<Skill, SkillInstance> entry : this.skills.entrySet()) {
            nbt.method_10566(entry.getKey().id().toString(), (class_2520)entry.getValue().toNbt());
        }
        return nbt;
    }

    public SkillInstance replace(SkillInstance oldInstance, SkillInstance newInstance) {
        if (oldInstance.equals(newInstance)) {
            return newInstance;
        }
        if (!oldInstance.skill.id.equals((Object)newInstance.skill.id)) {
            return newInstance;
        }
        return this.put(newInstance);
    }

    public SkillInstance put(SkillInstance instance) {
        return this.skills.put(instance.skill, instance);
    }

    public void putAll(SkillList skillList) {
        this.skills.putAll(skillList.skills);
    }

    public SkillInstance get(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.skills.computeIfAbsent(skill, SkillInstance::new);
    }

    public boolean isEmpty() {
        return this.skills.isEmpty();
    }
}

