/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.skillsmod.skills;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import local.ytk.skillsmod.SkillsMod;
import local.ytk.skillsmod.skills.LinkedEntityAttributeModifier;
import local.ytk.skillsmod.skills.Skill;
import local.ytk.skillsmod.skills.SkillData;
import local.ytk.skillsmod.skills.SkillInstance;
import local.ytk.skillsmod.skills.SkillList;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillManager
implements SimpleSynchronousResourceReloadListener {
    public static final Gson GSON = new Gson();
    public static final class_2960 ID = SkillsMod.id("skills");
    public static final SkillManager INSTANCE = new SkillManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(SkillManager.class);
    public final Map<class_2960, Skill> skills = new HashMap<class_2960, Skill>();

    public static boolean hasSkill(class_2960 id) {
        return SkillManager.INSTANCE.skills.containsKey(id);
    }

    public static boolean hasSkill(Skill skill) {
        return SkillManager.INSTANCE.skills.containsValue(skill);
    }

    public static Skill getSkill(class_2960 id) {
        return SkillManager.INSTANCE.skills.get(id);
    }

    public static Collection<Skill> getSkills() {
        return SkillManager.INSTANCE.skills.values();
    }

    public static SkillList createSkillList() {
        return new SkillList(SkillManager.getSkills().stream().map(SkillInstance::new).collect(TreeMap::new, (m, i) -> m.put(i.skill, i), Map::putAll));
    }

    public static SkillList createEmptySkillList() {
        return new SkillList(new TreeMap<Skill, SkillInstance>(Comparator.nullsLast(Skill::compareTo)));
    }

    public static SkillInstance createInstance(class_2960 id) {
        return SkillManager.INSTANCE.skills.computeIfAbsent(id, s -> {
            LOGGER.error("Skill not found: {}", (Object)id);
            return new Skill(id, 0, 100, new Skill.Level(100, List.of(), List.of()), IntList.of(), id);
        }).createInstance();
    }

    public static SkillInstance createInstance(class_2960 id, int level, int xp) {
        return SkillManager.INSTANCE.skills.computeIfAbsent(id, s -> {
            LOGGER.error("Skill not found: {} (level {}, {}xp)", new Object[]{id, level, xp});
            return new Skill(id, 0, 100, new Skill.Level(100, List.of(), List.of()), IntList.of(), id);
        }).createInstance(level, xp);
    }

    public static SkillList getSkills(class_1657 player) {
        return SkillData.getPlayerState(player).skillList();
    }

    public static void setSkills(class_1657 player, SkillList skillList) {
        SkillManager.getSkills(player).putAll(skillList);
    }

    public static void updateSkills(class_1657 player, SkillList skillList) {
        SkillManager.setSkills(player, skillList);
        for (SkillInstance skill : skillList.skills().values()) {
            if (skill.level == 0) continue;
            for (LinkedEntityAttributeModifier modifier : skill.skill.getModifiers(Math.min(skill.level, skill.skill.maxLevel))) {
                class_1324 attributeInstance = player.method_5996(modifier.attributeEntry());
                if (attributeInstance == null) {
                    attributeInstance = new class_1324(modifier.attributeEntry(), a -> {});
                }
                attributeInstance.method_61163(modifier.toEntityAttributeModifier());
            }
        }
    }

    public static SkillList getSkills(class_1657 player, SkillData data) {
        return data.getLocalPlayerState(player).skillList();
    }

    public static void setSkills(class_1657 player, SkillList skillList, SkillData data) {
        SkillManager.getSkills(player, data).putAll(skillList);
    }

    public static void updateSkills(class_1657 player, SkillList skillList, SkillData data) {
        SkillManager.setSkills(player, skillList, data);
        for (SkillInstance skill : skillList.skills().values()) {
            if (skill.level == 0) continue;
            for (LinkedEntityAttributeModifier modifier : skill.skill.getModifiers(Math.min(skill.level, skill.skill.maxLevel))) {
                class_1324 attributeInstance = player.method_5996(modifier.attributeEntry());
                if (attributeInstance == null) {
                    attributeInstance = new class_1324(modifier.attributeEntry(), a -> {});
                }
                attributeInstance.method_61163(modifier.toEntityAttributeModifier());
            }
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        Map resources = manager.method_14488("skill", path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    String content = new String(stream.readAllBytes());
                    JsonObject json = (JsonObject)GSON.fromJson(content, JsonObject.class);
                    if (json.has("enabled") && !json.get("enabled").getAsBoolean()) continue;
                    DataResult result = Skill.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    Pair pair = (Pair)result.getPartialOrThrow(IllegalArgumentException::new);
                    Skill skill = (Skill)pair.getFirst();
                    this.skills.put(skill.id, skill);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("e: ", (Throwable)e);
            }
        }
    }
}

