/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.the_lost_city;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import org.berezka.berezka_api.BerezkaAPIMain;
import org.berezka.berezka_api.BerezkaConfig;
import org.slf4j.Logger;

public class The_lost_city
implements ModInitializer {
    public BerezkaConfig configSpec;
    public String configName = "TheLostCity";
    public String MODID = "the_lost_city";
    private boolean debugMode = true;
    public static final Logger LOGGER = LogUtils.getLogger();
    private HashMap<String, List<Object>> defaultConfigVariables = new HashMap();

    public void onInitialize() {
        if (this.debugMode) {
            LOGGER.info("[The Lost City] onInitialize()");
        }
        this.createConfig();
        BerezkaAPIMain.registerResourcePackData((String)"the_lost_city", (String)"worldgen/structure/city.json", (String)this.generateStructureJson());
        BerezkaAPIMain.registerResourcePackData((String)"the_lost_city", (String)"worldgen/structure_set/city.json", (String)this.generateStructureSetJson());
        BerezkaAPIMain.registerResourcePackData((String)"the_lost_city", (String)"worldgen/template_pool/city.json", (String)this.generateTemplatePoolJson());
    }

    private void createConfig() {
        this.configSpec = new BerezkaConfig();
        this.initDefaultConfigValues();
        this.configSpec.loadConfig(this.configName, this.MODID, this.getDefaultConfig(), this.defaultConfigVariables);
    }

    public void initDefaultConfigValues() {
        this.defaultConfigVariables.put("CitySeparation", List.of("Minimum distance between two neighboring attempts.", Integer.valueOf(32)));
        this.defaultConfigVariables.put("CitySpacing", List.of("Average distance between two neighboring generation attempts.", Integer.valueOf(64)));
        this.defaultConfigVariables.put("biomes", List.of("Defines the list of biomes where cities can spawn.", "[\"plains\",\"snowy_plains\", \"sunflower_plains\"]"));
    }

    public String getDefaultConfig() {
        return "#Minimum distance between two neighboring attempts.\nCitySeparation = 32\n#Average distance between two neighboring generation attempts.\nCitySpacing = 64\n#Defines the list of biomes where cities can spawn.\nbiomes = [\"plains\",\"snowy_plains\", \"sunflower_plains\"]\n";
    }

    public String generateStructureJson() {
        return "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": 7,\n  \"max_distance_from_center\": 116,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_thin\",\n  \"start_height\": {\n    \"type\": \"minecraft:uniform\",\n    \"min_inclusive\": {\n      \"absolute\": 64\n    },\n    \"max_inclusive\": {\n      \"absolute\": 80\n    }\n  },\n  \"biomes\": %s,\n  \"use_expansion_hack\": false\n}\n".formatted(this.configSpec.getValue(this.MODID + ":biomes"));
    }

    public String generateStructureSetJson() {
        return "{\n  \"structures\": [\n    {\n      \"structure\": \"the_lost_city:city\",\n      \"weight\": 1\n    }\n  ],\n  \"placement\": {\n    \"type\": \"minecraft:random_spread\",\n    \"spacing\": %s,\n    \"separation\": %s,\n    \"salt\": 1687843387\n  },\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": 1,\n  \"max_distance_from_center\": 1,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_box\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"WORLD_SURFACE_WG\",\n  \"biomes\": \"forest\",\n  \"use_expansion_hack\": false\n}\n".formatted(this.configSpec.getValue(this.MODID + ":CitySpacing"), this.configSpec.getValue(this.MODID + ":CitySeparation"));
    }

    public String generateTemplatePoolJson() {
        return "{\n   \"name\": \"the_lost_city:city\",\n   \"fallback\": \"minecraft:empty\",\n   \"elements\": [\n     {\n       \"weight\": 1,\n       \"element\": {\n         \"element_type\": \"minecraft:single_pool_element\",\n         \"location\": \"the_lost_city:start\",\n         \"projection\": \"rigid\",\n         \"processors\": {\n           \"processors\": [\n             {\n               \"processor_type\": \"minecraft:block_ignore\",\n               \"blocks\": [\n                 {\n                   \"Name\": \"minecraft:structure_block\"\n                 }\n               ]\n             }\n           ]\n         }\n       }\n     }\n   ]\n }\n";
    }
}

