/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.the_lost_city;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.events.Comment;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.the_lost_city.init.TheLostCityModItems;
import org.slf4j.Logger;

@Mod(value="the_lost_city")
public class The_lost_city {
    private static final Gson GSON = new Gson();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Object BerezkaAPInstance = null;
    public static Method getValue = null;
    public static Method runCommand = null;
    public static final String MODID = "the_lost_city";
    public static boolean debugMode = true;
    public static String language = "en_us";
    public static boolean oldPluginsFolderExist = false;
    public static boolean useNewStructuresTypeAllowed = false;
    public static boolean useNewStructuresType = true;
    public static Boolean disableSpawners = false;
    public static String customCityType = "berezka_api:berezka_structures_extra";
    public static int CitySpacing = 34;
    public static int CitySeparation = 8;
    public static int VillagesCitySpacing = 34;
    public static int VillagesCitySeparation = 8;
    public static List<String> listOfResourcePaths = List.of("worldgen/structure", "worldgen/structure_set", "worldgen/template_pool");
    public static List<String> listOfResources = List.of("worldgen/structure/city.json", "worldgen/structure_set/city.json", "worldgen/template_pool/city_cars.json", "worldgen/template_pool/city_houses.json", "worldgen/template_pool/city_small_houses.json", "worldgen/template_pool/city_under.json", "worldgen/template_pool/city_cars.json", "worldgen/structure/villages_city.json", "worldgen/structure_set/villages_city.json", "worldgen/template_pool/villages_city_main_tiles.json", "worldgen/template_pool/survivorscamp.json", "worldgen/template_pool/spawners_husk.json", "worldgen/template_pool/spawners_pillager.json", "worldgen/template_pool/spawners_vindicator.json", "worldgen/template_pool/spawners_zombie.json", "worldgen/template_pool/spawners_zombie_moss.json");
    private static final String EMPTY_CITY_CARS_JSON = "{\n  \"name\": \"the_lost_city:city_cars\",\n  \"fallback\": \"minecraft:empty\",\n  \"elements\": []\n}";
    private static final String EMPTY_SPAWNER_JSON = "{\n  \"name\": \"the_lost_city:%s\",\n  \"fallback\": \"minecraft:empty\",\n  \"elements\": [\n      {\n        \"weight\": 1,\n        \"element\": {\n          \"element_type\": \"minecraft:single_pool_element\",\n          \"location\": \"the_lost_city:spawner_empty\",\n          \"projection\": \"rigid\",\n          \"processors\": {\n            \"processors\": []\n          }\n        }\n     }\n  ]\n}";
    private static final String EMPTY_CITY_JSON = "{\n\t\"type\": \"minecraft:jigsaw\",\n\t\"structure_rotation\": 90,\n\t\"start_pool\": \"the_lost_city:city\",\n\t\"size\": 1,\n\t\"max_distance_from_center\": 10,\n\t\"spawn_overrides\": {},\n\t\"step\": \"surface_structures\",\n\t\"terrain_adaptation\": \"beard_box\",\n\t\"start_height\": {\n\t\t\"absolute\": 0\n\t},\n\t\"project_start_to_heightmap\": \"OCEAN_FLOOR\",\n\t\"biomes\": [],\n\t\"use_expansion_hack\": true\n}\n";
    public static List<String> villagesCityMainTilesList = List.of("the_lost_city:villages_city_main_tile1", "the_lost_city:villages_city_main_tile2", "the_lost_city:a_v-city_street_v2_d2", "the_lost_city:a_v-city_street_v1_d2", "the_lost_city:a_v-city_hospital_v1_d2");
    public static Map<String, String> replacedStructures = new HashMap<String, String>();
    public static List<String> disabledStructures = new ArrayList<String>(List.of());
    public static List<String> loadedHouses = new ArrayList<String>(List.of());
    public static List<String> loadedBases = new ArrayList<String>(List.of());
    public static List<String> loadedUnderTiles = new ArrayList<String>(List.of());
    public static List<String> loadedCars = new ArrayList<String>(List.of("the_lost_city:car", "the_lost_city:car2", "the_lost_city:car3", "the_lost_city:car4", "the_lost_city:car5"));
    public static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> enTranslations = new HashMap<String, String>();
    public static final Map<String, String> ruTranslations = new HashMap<String, String>();
    public static final Map<String, String> deTranslations = new HashMap<String, String>();
    public static final Map<String, String> frTranslations = new HashMap<String, String>();
    public static final Map<String, String> esTranslations = new HashMap<String, String>();
    public static List<String> defaultHouses = List.of("the_lost_city:house01", "the_lost_city:house02", "the_lost_city:house03", "the_lost_city:cafe1", "the_lost_city:cafe2", "the_lost_city:cafe3", "the_lost_city:small_house1", "the_lost_city:small_house2", "the_lost_city:small_house3", "the_lost_city:small_house11", "the_lost_city:small_house21", "the_lost_city:cafe4", "the_lost_city:brick_house1", "the_lost_city:family_house1", "the_lost_city:family_house2", "the_lost_city:family_house3", "the_lost_city:house_with_car", "the_lost_city:skyscraper1", "the_lost_city:skyscraper2", "the_lost_city:family_house31", "the_lost_city:store", "the_lost_city:tall_building", "the_lost_city:blue-tall-house_b_1_0", "the_lost_city:white-tall-office_b_2_0", "the_lost_city:tall-building_a_1_1", "the_lost_city:library_a_2_0");
    public static List<String> defaultBases = List.of("the_lost_city:base1", "the_lost_city:base0", "the_lost_city:police_station1", "the_lost_city:parking_e_1", "the_lost_city:base1", "the_lost_city:base0", "the_lost_city:base1", "the_lost_city:base0", "the_lost_city:greenhouse_r_2_0", "the_lost_city:orange-yellow-house-a-2-0", "the_lost_city:big_house_a_2_0", "the_lost_city:brown-big-house-a-2-0", "the_lost_city:park_street_a_0_1_v1", "the_lost_city:playground_street_a_0_1_v1", "the_lost_city:m_hryshevka", "the_lost_city:gas_station", "the_lost_city:m_workshop", "the_lost_city:m_pizzeria", "the_lost_city:m_pub", "the_lost_city:m_police_station", "the_lost_city:m_skyscraper", "the_lost_city:t_big_house_0", "the_lost_city:m_tc", "the_lost_city:m_library", "the_lost_city:d_city_house1_v1_d2", "the_lost_city:d_city_cinema_v1_d2", "the_lost_city:d_city_house2_v1_d1", "the_lost_city:d_city_shop_v1_d2", "the_lost_city:d_city_shop_v2_d2", "the_lost_city:small-brick-house_by-agrek_d2");

    public The_lost_city() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus bus = context.getModEventBus();
        TheLostCityModItems.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        oldPluginsFolderExist = this.doOldPluginsDataExist();
        enTranslations.put("description1", "Should cars spawn?");
        enTranslations.put("description2", "Average distance between two neighboring generation attempts.");
        enTranslations.put("description3", "Minimum distance between two neighboring attempts.");
        enTranslations.put("description4", "Defines the list of biomes where cities can spawn.");
        enTranslations.put("description5", "It is the jigsaw depth limit and it has a maximum of 30.");
        enTranslations.put("description6", "Defines the maximum distance of any piece from the structure start.");
        enTranslations.put("description7", "Disables the generation of monster spawners in the city structure.");
        ruTranslations.put("description1", "\u0411\u0443\u0434\u0443\u0442 \u043b\u0438 \u0432 \u0433\u043e\u0440\u043e\u0434\u0430\u0445 \u043c\u0430\u0448\u0438\u043d\u044b");
        ruTranslations.put("description2", "\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0434\u0432\u0443\u043c\u044f \u0441\u043e\u0441\u0435\u0434\u043d\u0438\u043c\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438.");
        ruTranslations.put("description3", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0434\u0432\u0443\u043c\u044f \u0441\u043e\u0441\u0435\u0434\u043d\u0438\u043c\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438.");
        ruTranslations.put("description4", "\u0411\u0438\u043e\u043c\u044b \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0433\u043e\u0440\u043e\u0434\u0430.");
        ruTranslations.put("description5", "\u042d\u0442\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0433\u043b\u0443\u0431\u0438\u043d\u044b jigsaw-\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440 \u0441 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c\u043e\u043c 30 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        ruTranslations.put("description6", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043b\u044e\u0431\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b.");
        ruTranslations.put("description7", "\u041e\u0442\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e \u0441\u043f\u0430\u0432\u043d\u0435\u0440\u043e\u0432 \u043c\u043e\u043d\u0441\u0442\u0440\u043e\u0432 \u0432 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0433\u043e\u0440\u043e\u0434\u0430.");
        deTranslations.put("description1", "Sollen Autos erscheinen?");
        deTranslations.put("description2", "Durchschnittliche Entfernung zwischen zwei aufeinander folgenden Generierungsversuchen.");
        deTranslations.put("description3", "Mindestabstand zwischen zwei aufeinander folgenden Versuchen.");
        deTranslations.put("description4", "Legt die Biome fest, in denen St\u00e4dte erscheinen k\u00f6nnen.");
        deTranslations.put("description5", "Es ist das Jigsaw-Tiefenlimit mit einem Maximum von 30.");
        deTranslations.put("description6", "Definiert die maximale Entfernung eines Teils vom Strukturanfang.");
        deTranslations.put("description7", "Deaktiviert das Erzeugen von Monstergeneratoren in der Stadtstruktur.");
        esTranslations.put("description1", "\u00bfDeber\u00edan aparecer coches?");
        esTranslations.put("description2", "Distancia promedio entre dos intentos de generaci\u00f3n vecinos.");
        esTranslations.put("description3", "Distancia m\u00ednima entre dos intentos vecinos.");
        esTranslations.put("description4", "Define la lista de biomas donde pueden generarse ciudades.");
        esTranslations.put("description5", "Es el l\u00edmite de profundidad del rompecabezas (jigsaw) y tiene un m\u00e1ximo de 30.");
        esTranslations.put("description6", "Define la distancia m\u00e1xima de cualquier pieza desde el inicio de la estructura.");
        esTranslations.put("description7", "Desactiva la generaci\u00f3n de generadores de monstruos en la estructura de la ciudad.");
        frTranslations.put("description1", "Les voitures doivent-elles appara\u00eetre ?");
        frTranslations.put("description2", "Distance moyenne entre deux tentatives de g\u00e9n\u00e9ration voisines.");
        frTranslations.put("description3", "Distance minimale entre deux tentatives voisines.");
        frTranslations.put("description4", "D\u00e9finit la liste des biomes o\u00f9 les villes peuvent appara\u00eetre.");
        frTranslations.put("description5", "C'est la limite de profondeur des structures jigsaw, avec un maximum de 30.");
        frTranslations.put("description6", "D\u00e9finit la distance maximale de n'importe quelle pi\u00e8ce par rapport au d\u00e9but de la structure.");
        frTranslations.put("description7", "D\u00e9sactive la g\u00e9n\u00e9ration des cages de monstres dans la structure de la ville.");
        translations.put("en_us", enTranslations);
        translations.put("ru_ru", ruTranslations);
        translations.put("de_de", deTranslations);
        translations.put("es_es", esTranslations);
        translations.put("fr_fr", frTranslations);
        if (ModList.get().isLoaded("berezka_api")) {
            LOGGER.info("[The Lost City] mod berezka_api is founded. access to API...");
            BerezkaAPInstance = Berezka_api.getAPI();
        } else {
            LOGGER.error("[The Lost City] mod berezka_api is not loaded.");
        }
        LOGGER.info("[The Lost City] mod berezka api: " + String.valueOf(BerezkaAPInstance) + " is loaded: " + (BerezkaAPInstance != null));
        if (BerezkaAPInstance != null) {
            try {
                getValue = BerezkaAPInstance.getClass().getMethod("getValue", String.class);
                runCommand = BerezkaAPInstance.getClass().getMethod("runCommand", Level.class, Player.class, String.class);
                language = berezka_api_main.getLanguage();
                int apiVersion = berezka_api_main.getVersion();
                if (apiVersion >= 2) {
                    useNewStructuresTypeAllowed = true;
                }
                LOGGER.info("[The Lost City] API version is " + apiVersion + " use new Structures type: " + useNewStructuresType);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("[The Lost City] Error: " + String.valueOf(e));
            }
            context.getModEventBus().addListener(this::onConfigLoad);
            this.createConfig();
            this.registerMod(context);
        }
    }

    public void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals(MODID)) {
            translations.clear();
            ruTranslations.clear();
            enTranslations.clear();
            deTranslations.clear();
            esTranslations.clear();
            frTranslations.clear();
            disableSpawners = (Boolean)berezka_api_main.getValue((String)"the_lost_city:DisableSpawners");
            boolean bl = useNewStructuresType = (Boolean)berezka_api_main.getValue((String)"the_lost_city:UseCustomStructureType") != false && useNewStructuresTypeAllowed;
            if (debugMode) {
                LOGGER.info("[The Lost City] OnConfigLoad, translations file were deleted. (for configs) data:{disableSpawners:%s, useCustomStructureType:%s}".formatted(disableSpawners, useNewStructuresType));
            }
        }
    }

    public void createConfig() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        LinkedHashMap<String, List<Object>> configParams = new LinkedHashMap<String, List<Object>>();
        configParams.put("UseCustomStructureType", Arrays.asList(Boolean.class, The_lost_city.getText("Uses custom Strucutre type. (custom structure type has more spawn checks, buy may have some generation issues when using /locate or /place)"), true, null, null));
        configParams.put("comment1", Arrays.asList(Comment.class, The_lost_city.getText("--------------------------------------------City Settings--------------------------------------------"), null, null, null));
        configParams.put("SpawnCars", Arrays.asList(Boolean.class, The_lost_city.getText("description1"), true, null, null));
        configParams.put("DisableSpawners", Arrays.asList(Boolean.class, The_lost_city.getText("description7"), false, null, null));
        configParams.put("CitySize", Arrays.asList(Integer.class, The_lost_city.getText("description5"), 15, 1, 30));
        configParams.put("CityDistanceFromCenter", Arrays.asList(Integer.class, The_lost_city.getText("description6"), 128, 1, 1000));
        configParams.put("comment2", Arrays.asList(Comment.class, The_lost_city.getText("--------------------------------------------City Spawn Settings--------------------------------------------"), null, null, null));
        configParams.put("CitySpacing", Arrays.asList(Integer.class, The_lost_city.getText("description2"), 34, 0, 4096));
        configParams.put("CitySeparation", Arrays.asList(Integer.class, The_lost_city.getText("description3"), 8, 0, 4096));
        configParams.put("CityStep", Arrays.asList(String.class, The_lost_city.getText("defines step of structure spawn ('step' in default structure.json)"), "surface_structures", null, null));
        configParams.put("CityTerrainAdaptation", Arrays.asList(String.class, The_lost_city.getText("defines terrain adaptation of structure spawn ('terrain_adaptation' in default structure.json)"), "beard_thin", null, null));
        configParams.put("CityStartHeight", Arrays.asList(String.class, The_lost_city.getText("defines start height adaptation of structure spawn ('start_height' in default structure.json)"), "\"absolute\": 1\n", null, null));
        configParams.put("CityProjectStartToHeightmap", Arrays.asList(String.class, The_lost_city.getText("defines project start to heightmap of structure spawn ('project_start_to_heightmap' in default structure.json)"), "OCEAN_FLOOR", null, null));
        configParams.put("CityBiomes", Arrays.asList(List.class, The_lost_city.getText("description4"), List.of("plains", "snowy_plains", "sunflower_plains", "snowy_plains", "desert"), null, null));
        configParams.put("comment3", Arrays.asList(Comment.class, The_lost_city.getText("--------------------------------------------Villages City Spawn Settings--------------------------------------------"), null, null, null));
        configParams.put("VillagesCityBiomes", Arrays.asList(List.class, The_lost_city.getText("description4"), List.of("taiga", "plains", "snowy_plains", "sunflower_plains", "snowy_taiga"), null, null));
        configParams.put("VillagesCitySeparation", Arrays.asList(Integer.class, The_lost_city.getText("description3"), 16, 0, 4096));
        configParams.put("VillagesCitySpacing", Arrays.asList(Integer.class, The_lost_city.getText("description2"), 34, 0, 4096));
        if (debugMode) {
            LOGGER.info("[The Lost City] param list: " + String.valueOf(configParams));
        }
        berezka_api_main.createConfig((String)MODID, (String)"TheLostCity", (FMLJavaModLoadingContext)context, configParams);
    }

    public void registerMod(FMLJavaModLoadingContext context) {
        berezka_api_main.registerMod((String)MODID, (String)"org.berezka.the_lost_city.The_lost_city");
    }

    public static boolean isResourceListened(String path) {
        return listOfResources.contains(path);
    }

    public static List<String> handleResource(String path) {
        ArrayList<String> data = new ArrayList<String>(List.of());
        if (path.equals("worldgen/structure_set")) {
            data.add("worldgen/structure_set/city.json");
            data.add("worldgen/structure_set/villages_city.json");
        } else if (path.equals("worldgen/structure")) {
            data.add("worldgen/structure/city.json");
            data.add("worldgen/structure/villages_city.json");
        } else if (path.equals("worldgen/template_pool")) {
            data.add("worldgen/template_pool/city_cars.json");
            data.add("worldgen/template_pool/city_houses.json");
            data.add("worldgen/template_pool/city_small_houses.json");
            data.add("worldgen/template_pool/city_under.json");
            data.add("worldgen/template_pool/villages_city_main_tiles.json");
            data.add("worldgen/template_pool/survivorscamp.json");
            if (disableSpawners.booleanValue()) {
                if (debugMode) {
                    LOGGER.info("[The Lost City] adding data for disabling spawners.");
                }
                data.add("worldgen/template_pool/spawners_husk.json");
                data.add("worldgen/template_pool/spawners_pillager.json");
                data.add("worldgen/template_pool/spawners_vindicator.json");
                data.add("worldgen/template_pool/spawners_zombie.json");
                data.add("worldgen/template_pool/spawners_zombie_moss.json");
            }
        }
        if (debugMode) {
            LOGGER.info("[The Lost City] handle resource: input: " + path + ", output: " + String.valueOf(data));
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    public static String getJson(String jsonFileName) {
        if (debugMode) {
            LOGGER.info("[The Lost City] getJsonMethod info: " + jsonFileName);
        }
        switch (jsonFileName) {
            case "worldgen/structure_set/city.json": {
                return The_lost_city.createStructureSetJson("city", "City", 1687843387);
            }
            case "worldgen/structure/city.json": {
                List biomes = (List)The_lost_city.getValueMethod("CityBiomes");
                int size = (Integer)The_lost_city.getValueMethod("CitySize");
                int n = (Integer)The_lost_city.getValueMethod("CityDistanceFromCenter");
                String step = (String)The_lost_city.getValueMethod("CityStep");
                String terrainAdaptation = (String)The_lost_city.getValueMethod("CityTerrainAdaptation");
                String startHeight = (String)The_lost_city.getValueMethod("CityStartHeight");
                String project = (String)The_lost_city.getValueMethod("CityProjectStartToHeightmap");
                return biomes != null ? The_lost_city.createStructureJson("city", biomes, size, n, step, terrainAdaptation, startHeight, project) : EMPTY_CITY_JSON;
            }
            case "worldgen/template_pool/city_cars.json": {
                ArrayList<String> carsToUse = new ArrayList<String>();
                if (loadedCars != null && !loadedCars.isEmpty()) {
                    for (String string : loadedCars) {
                        void var5_15;
                        if (debugMode) {
                            LOGGER.info("[The Lost City] car: " + string + " blacklisted?: " + disabledStructures.contains(string));
                        }
                        if (disabledStructures.contains(string)) continue;
                        if (replacedStructures.containsKey(string)) {
                            String string2 = replacedStructures.get(string);
                        }
                        carsToUse.add((String)var5_15);
                    }
                }
                if (debugMode) {
                    LOGGER.info("[The Lost City] cars list: {}", carsToUse);
                }
                return (Boolean)The_lost_city.getValueMethod("SpawnCars") != false ? The_lost_city.createTemplatesPoolJson("city_cars", carsToUse) : EMPTY_CITY_CARS_JSON;
            }
            case "worldgen/template_pool/city_houses.json": {
                ArrayList<String> streetsToUse = new ArrayList<String>();
                if (defaultBases != null && !defaultBases.isEmpty()) {
                    for (String string : defaultBases) {
                        void var5_18;
                        if (replacedStructures.containsKey(string)) {
                            String string3 = replacedStructures.get(string);
                        }
                        streetsToUse.add((String)var5_18);
                    }
                }
                if (loadedBases != null && !loadedBases.isEmpty()) {
                    for (String string : loadedBases) {
                        void var5_24;
                        if (replacedStructures.containsKey(string)) {
                            String string4 = replacedStructures.get(string);
                        }
                        streetsToUse.add((String)var5_24);
                    }
                }
                if (oldPluginsFolderExist) {
                    List<String> loadedBasesFromFiles = The_lost_city.loadDataFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + MODID + File.separator + "custom_bases");
                    for (String street : loadedBasesFromFiles) {
                        if (replacedStructures.containsKey(street)) {
                            street = replacedStructures.get(street);
                        }
                        streetsToUse.add(street);
                    }
                }
                return The_lost_city.createTemplatesPoolJson("city_houses", streetsToUse);
            }
            case "worldgen/template_pool/city_small_houses.json": {
                ArrayList<String> housesToUse = new ArrayList<String>();
                for (String string : defaultHouses) {
                    void var5_26;
                    if (disabledStructures.contains(string)) continue;
                    if (replacedStructures.containsKey(string)) {
                        String string5 = replacedStructures.get(string);
                    }
                    housesToUse.add((String)var5_26);
                }
                if (loadedHouses != null && !loadedHouses.isEmpty()) {
                    for (String string : loadedHouses) {
                        void var5_32;
                        if (disabledStructures.contains(string)) continue;
                        if (replacedStructures.containsKey(string)) {
                            String string6 = replacedStructures.get(string);
                        }
                        housesToUse.add((String)var5_32);
                    }
                }
                if (oldPluginsFolderExist) {
                    List<String> loadedHousesFromFiles = The_lost_city.loadDataFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + MODID + File.separator + "custom_houses");
                    for (String house : loadedHousesFromFiles) {
                        if (disabledStructures.contains(house)) continue;
                        if (replacedStructures.containsKey(house)) {
                            house = replacedStructures.get(house);
                        }
                        housesToUse.add(house);
                    }
                }
                return The_lost_city.createTemplatesPoolJson("city_houses", housesToUse);
            }
            case "worldgen/structure/villages_city.json": {
                List biomes = (List)The_lost_city.getValueMethod("VillagesCityBiomes");
                return The_lost_city.createStructureVillagesCityJson(biomes);
            }
            case "worldgen/structure_set/villages_city.json": {
                return The_lost_city.createStructureSetJson("villages_city", "VillagesCity", 1973954143);
            }
            case "worldgen/template_pool/city_under.json": {
                ArrayList<String> underPartsToUse = new ArrayList<String>();
                List<String> defaultTiles = List.of("the_lost_city:under1", "the_lost_city:under2");
                for (String tile : defaultTiles) {
                    if (disabledStructures.contains(tile)) continue;
                    if (replacedStructures.containsKey(tile)) {
                        tile = replacedStructures.get(tile);
                    }
                    underPartsToUse.add(tile);
                }
                if (loadedUnderTiles != null && !loadedUnderTiles.isEmpty()) {
                    for (String tile : loadedUnderTiles) {
                        if (disabledStructures.contains(tile)) continue;
                        if (replacedStructures.containsKey(tile)) {
                            tile = replacedStructures.get(tile);
                        }
                        underPartsToUse.add(tile);
                    }
                }
                return The_lost_city.createTemplatesPoolJson("city_under", underPartsToUse);
            }
            case "worldgen/template_pool/survivorscamp.json": {
                return The_lost_city.createTemplatePoolJson("survivorscamp", "the_lost_city:survivor_camp");
            }
            case "worldgen/template_pool/villages_city_main_tiles.json": {
                return The_lost_city.createTemplatesPoolJson("villages_city_main_tiles", villagesCityMainTilesList);
            }
        }
        if (debugMode) {
            LOGGER.info("[The Lost City] file %s. data:{startsWith: %s, disableSpawners: %s}".formatted(jsonFileName, jsonFileName.startsWith("worldgen/template_pool/spawners_"), disableSpawners));
        }
        if (jsonFileName.startsWith("worldgen/template_pool/spawners_") && disableSpawners.booleanValue()) {
            String name = jsonFileName.replace(".json", "").replace("worldgen/template_pool/", "");
            if (debugMode) {
                LOGGER.info("[The Lost City] returning spawner template for: %s.".formatted(name));
            }
            return EMPTY_SPAWNER_JSON.formatted(name);
        }
        return null;
    }

    public static String createStructureJson(String nameLocation, List<String> biomes, int size, int maxDistance, String step, String terrainAdaptation, String startHeight, String project) {
        StringBuilder biomesJson = new StringBuilder();
        for (int i = 0; i < biomes.size(); ++i) {
            biomesJson.append("\"").append(biomes.get(i)).append("\"");
            if (i >= biomes.size() - 1) continue;
            biomesJson.append(", ");
        }
        String data = "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"%s:%s\",\n  \"size\": %s,\n  \"max_distance_from_center\": %s,\n  \"spawn_overrides\": {},\n  \"step\": \"%s\",\n  \"terrain_adaptation\": \"%s\",\n  \"start_height\": {\n    %s\n  },\n  \"project_start_to_heightmap\": \"%s\",\n  \"biomes\": [\n".formatted(MODID, nameLocation, size, maxDistance, step, terrainAdaptation, startHeight, project) + String.valueOf(biomesJson) + "  ],\n  \"use_expansion_hack\": false\n}\n";
        if (debugMode) {
            LOGGER.info("[The Lost City] createStructure for the_lost_city returns: " + data);
        }
        return data;
    }

    public static String createStructureSetJson(String nameLocation, String configName, int salt) {
        String data = "{\n  \"structures\": [\n    {\n      \"structure\": \"%s:%s\",\n      \"weight\": 1\n    }\n  ],\n  \"placement\": {\n    \"type\": \"minecraft:random_spread\",\n    \"spacing\": %s,\n    \"separation\": %s,\n    \"salt\": %s\n  }\n}\n".formatted(MODID, nameLocation, The_lost_city.getValueMethod(String.format("%sSpacing", configName)), The_lost_city.getValueMethod(String.format("%sSeparation", configName)), salt);
        if (debugMode) {
            LOGGER.info("[The Lost City] createStructureSet for the_lost_city returns: " + data + " [config: " + String.format("%sSeparation", configName) + " ]");
        }
        return data;
    }

    public static String createTemplatePoolJson(String name, String structureName) {
        JsonObject root = new JsonObject();
        root.addProperty("name", String.format("%s:%s", MODID, name));
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        if (debugMode) {
            LOGGER.info("[The Lost City] createTemplatePoolJson: structure: " + structureName + " replaced?: " + replacedStructures.containsKey(structureName));
        }
        if (replacedStructures.containsKey(structureName)) {
            JsonObject element = The_lost_city.createElement(replacedStructures.get(structureName));
            if (debugMode) {
                LOGGER.info("[The Lost City] createElement: structure: " + structureName + " replaced: " + replacedStructures.get(structureName));
            }
            elements.add((JsonElement)element);
        } else {
            JsonObject element = The_lost_city.createElement(structureName);
            elements.add((JsonElement)element);
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    public static String createTemplatesPoolJson(String name, List<String> structureNames) {
        JsonObject root = new JsonObject();
        root.addProperty("name", String.format("%s:%s", MODID, name));
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        for (String structureName : structureNames) {
            if (replacedStructures.containsKey(structureName)) {
                structureName = replacedStructures.get(structureName);
            }
            JsonObject element = The_lost_city.createElement(structureName);
            elements.add((JsonElement)element);
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    public static String createCityJson(List<String> expansionZonesList) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        jsonBuilder.append("  \"structures\": [\n");
        jsonBuilder.append("    {\n");
        jsonBuilder.append("      \"structure\": \"the_lost_city:city\",\n");
        jsonBuilder.append("      \"weight\": 1\n");
        jsonBuilder.append("    }\n");
        jsonBuilder.append("  ],\n");
        jsonBuilder.append("  \"placement\": {\n");
        jsonBuilder.append("    \"type\": \"minecraft:random_spread\",\n");
        jsonBuilder.append("    \"spacing\": ").append(The_lost_city.getValueMethod("CitySpacing")).append(",\n");
        jsonBuilder.append("    \"separation\": ").append(The_lost_city.getValueMethod("CitySeparation")).append(",\n");
        jsonBuilder.append("    \"salt\": 1687843387\n");
        if (expansionZonesList != null && !expansionZonesList.isEmpty()) {
            jsonBuilder.append("    ,\"expansion_zones\": [\n");
            for (String entry : expansionZonesList) {
                String[] parts = entry.split(" - ");
                if (parts.length != 2) continue;
                String structureName = parts[0].trim();
                int distance = Integer.parseInt(parts[1].trim());
                jsonBuilder.append("      {\n");
                jsonBuilder.append("        \"structure\": \"").append(structureName).append("\",\n");
                jsonBuilder.append("        \"distance\": ").append(distance).append("\n");
                jsonBuilder.append("      },\n");
            }
            jsonBuilder.setLength(jsonBuilder.length() - 2);
            jsonBuilder.append("\n    ]\n");
        }
        jsonBuilder.append("  }\n");
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    public static String createStructureSetVillagesCityJson(List<String> expansionZonesList) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        jsonBuilder.append("  \"structures\": [\n");
        jsonBuilder.append("    {\n");
        jsonBuilder.append("      \"structure\": \"the_lost_city:villages_city\",\n");
        jsonBuilder.append("      \"weight\": 1\n");
        jsonBuilder.append("    }\n");
        jsonBuilder.append("  ],\n");
        jsonBuilder.append("  \"placement\": {\n");
        jsonBuilder.append("    \"type\": \"minecraft:random_spread\",\n");
        jsonBuilder.append("    \"spacing\": ").append(The_lost_city.getValueMethod("VillagesCitySpacing")).append(",\n");
        jsonBuilder.append("    \"separation\": ").append(The_lost_city.getValueMethod("VillagesCitySeparation")).append(",\n");
        jsonBuilder.append("    \"salt\": 1973954143\n");
        if (expansionZonesList != null && !expansionZonesList.isEmpty()) {
            jsonBuilder.append("    ,\"expansion_zones\": [\n");
            for (String entry : expansionZonesList) {
                String[] parts = entry.split(" - ");
                if (parts.length != 2) continue;
                String structureName = parts[0].trim();
                int distance = Integer.parseInt(parts[1].trim());
                jsonBuilder.append("      {\n");
                jsonBuilder.append("        \"structure\": \"").append(structureName).append("\",\n");
                jsonBuilder.append("        \"distance\": ").append(distance).append("\n");
                jsonBuilder.append("      },\n");
            }
            jsonBuilder.setLength(jsonBuilder.length() - 2);
            jsonBuilder.append("\n    ]\n");
        }
        jsonBuilder.append("  }\n");
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String createTMPCityBasesJson(List<? extends String> basesList, List<String> housesList, List<String> loadedBasesList) {
        JsonObject element;
        JsonObject root = new JsonObject();
        root.addProperty("name", "the_lost_city:city_houses");
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        if (basesList != null && !basesList.isEmpty()) {
            for (String string : basesList) {
                void var6_6;
                if (replacedStructures.containsKey(string)) {
                    String string2 = replacedStructures.get(string);
                }
                element = The_lost_city.createElement((String)var6_6);
                elements.add((JsonElement)element);
            }
        }
        if (housesList != null && !housesList.isEmpty()) {
            for (String string : housesList) {
                void var6_12;
                if (replacedStructures.containsKey(string)) {
                    String string3 = replacedStructures.get(string);
                }
                element = The_lost_city.createElement((String)var6_12);
                elements.add((JsonElement)element);
            }
        }
        if (loadedBasesList != null && !loadedBasesList.isEmpty()) {
            for (String string : loadedBasesList) {
                void var6_16;
                if (replacedStructures.containsKey(string)) {
                    String string4 = replacedStructures.get(string);
                }
                element = The_lost_city.createElement((String)var6_16);
                elements.add((JsonElement)element);
            }
        }
        if (oldPluginsFolderExist) {
            List<String> loadedBasesFromFiles = The_lost_city.loadDataFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + MODID + File.separator + "custom_bases");
            for (String house : loadedBasesFromFiles) {
                if (replacedStructures.containsKey(house)) {
                    house = replacedStructures.get(house);
                }
                JsonObject element2 = The_lost_city.createElement(house);
                elements.add((JsonElement)element2);
            }
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    public static String createAdvancedJson(List<String> biomes) {
        if (biomes == null) {
            LOGGER.info("[The Lost City] biomes list is empty");
            return "{\n  \"type\": \"minecraft:jigsaw\",\n  \"structure_rotation\": 90,\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": 1,\n  \"max_distance_from_center\": 10,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_box\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"OCEAN_FLOOR\",\n  \"biomes\": [],\n  \"use_expansion_hack\": true\n}";
        }
        LOGGER.info("[The Lost City] biomes list is not empty");
        StringBuilder biomesJson = new StringBuilder();
        for (int i = 0; i < biomes.size(); ++i) {
            biomesJson.append("\"").append(biomes.get(i)).append("\"");
            if (i >= biomes.size() - 1) continue;
            biomesJson.append(", ");
        }
        int size = (Integer)The_lost_city.getValueMethod("CitySize");
        int distance = (Integer)The_lost_city.getValueMethod("CityDistanceFromCenter");
        String strType = "minecraft:jigsaw";
        if (useNewStructuresType) {
            strType = customCityType;
        } else {
            if (size > 7) {
                size = 7;
            }
            if (distance > 116) {
                distance = 116;
            }
        }
        String jsonContent = "{\n  \"type\": \"%s\",\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": %s,\n  \"max_distance_from_center\": %s,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_box\",\n  \"start_height\": {\n        \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"OCEAN_FLOOR\",\n  \"biomes\": [\n".formatted(strType, size, distance) + String.valueOf(biomesJson) + "  ],\n  \"use_expansion_hack\": true\n}";
        if (debugMode) {
            LOGGER.info("[The Lost City] cityAdvanced json: " + jsonContent);
        }
        return jsonContent;
    }

    public static String createStructureVillagesCityJson(List<String> biomes) {
        if (biomes == null) {
            LOGGER.info("[The Lost City] biomes list is empty");
            return "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:villages_city\",\n  \"size\": 7,\n  \"max_distance_from_center\": 116,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_thin\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"OCEAN_FLOOR\",\n  \"biomes\": [],\n  \"use_expansion_hack\": false\n}";
        }
        LOGGER.info("[The Lost City] biomes list is not empty");
        StringBuilder biomesJson = new StringBuilder();
        for (int i = 0; i < biomes.size(); ++i) {
            biomesJson.append("\"").append(biomes.get(i)).append("\"");
            if (i >= biomes.size() - 1) continue;
            biomesJson.append(", ");
        }
        String jsonContent = "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:villages_city\",\n  \"size\": 7,\n  \"max_distance_from_center\": 116,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_thin\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"OCEAN_FLOOR\",\n  \"biomes\": [\n    " + biomesJson.toString() + "\n  ],\n  \"use_expansion_hack\": false\n}";
        if (debugMode) {
            LOGGER.info("[The Lost City] VillagesCityAdvanced json: " + jsonContent);
        }
        return jsonContent;
    }

    public static JsonObject createElement(String location) {
        JsonObject element = new JsonObject();
        element.addProperty("weight", (Number)100);
        JsonObject elementDetails = new JsonObject();
        elementDetails.addProperty("element_type", "minecraft:single_pool_element");
        elementDetails.addProperty("location", location);
        elementDetails.addProperty("projection", "rigid");
        JsonObject processors = new JsonObject();
        processors.add("processors", (JsonElement)new JsonArray());
        elementDetails.add("processors", (JsonElement)processors);
        element.add("element", (JsonElement)elementDetails);
        return element;
    }

    public static String createTMPCityHousesJson(Set<String> blacklist, List<String> loadedHouses) {
        JsonObject element;
        JsonObject root = new JsonObject();
        root.addProperty("name", "the_lost_city:city_houses");
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        for (String house : defaultHouses) {
            if (blacklist.contains(house)) continue;
            if (replacedStructures.containsKey(house)) {
                house = replacedStructures.get(house);
            }
            element = The_lost_city.createElement(house);
            elements.add((JsonElement)element);
        }
        if (loadedHouses != null && !loadedHouses.isEmpty()) {
            for (String house : loadedHouses) {
                if (blacklist.contains(house)) continue;
                if (replacedStructures.containsKey(house)) {
                    house = replacedStructures.get(house);
                }
                element = The_lost_city.createElement(house);
                elements.add((JsonElement)element);
            }
        }
        if (oldPluginsFolderExist) {
            List<String> loadedHousesFromFiles = The_lost_city.loadDataFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + MODID + File.separator + "custom_houses");
            for (String house : loadedHousesFromFiles) {
                if (blacklist.contains(house)) continue;
                if (replacedStructures.containsKey(house)) {
                    house = replacedStructures.get(house);
                }
                JsonObject element2 = The_lost_city.createElement(house);
                elements.add((JsonElement)element2);
            }
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    public static String createCityUnder() {
        JsonObject element;
        JsonObject root = new JsonObject();
        root.addProperty("name", "the_lost_city:city_under");
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        List<String> defaultTiles = List.of("the_lost_city:under1", "the_lost_city:under2");
        for (String tile : defaultTiles) {
            if (replacedStructures.containsKey(tile)) {
                tile = replacedStructures.get(tile);
            }
            element = The_lost_city.createElement(tile);
            elements.add((JsonElement)element);
        }
        if (loadedUnderTiles != null && !loadedUnderTiles.isEmpty()) {
            for (String tile : loadedUnderTiles) {
                if (replacedStructures.containsKey(tile)) {
                    tile = replacedStructures.get(tile);
                }
                element = The_lost_city.createElement(tile);
                elements.add((JsonElement)element);
            }
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    public static String createCarsJson() {
        if (((Boolean)The_lost_city.getValueMethod("SpawnCars")).booleanValue()) {
            JsonObject root = new JsonObject();
            root.addProperty("name", "the_lost_city:city_cars");
            root.addProperty("fallback", "minecraft:empty");
            JsonArray elements = new JsonArray();
            if (loadedCars != null && !loadedCars.isEmpty()) {
                for (String car : loadedCars) {
                    if (debugMode) {
                        LOGGER.info("[The Lost City] car: " + car + " blacklisted?: " + disabledStructures.contains(car));
                    }
                    if (disabledStructures.contains(car)) continue;
                    if (replacedStructures.containsKey(car)) {
                        car = replacedStructures.get(car);
                    }
                    JsonObject element = The_lost_city.createElement(car);
                    elements.add((JsonElement)element);
                }
            }
            root.add("elements", (JsonElement)elements);
            return GSON.toJson((JsonElement)root);
        }
        return EMPTY_CITY_CARS_JSON;
    }

    public static List<String> getResources() {
        return listOfResourcePaths;
    }

    public static Object getValueMethod(String varName) {
        return The_lost_city.getValueMethod(varName, MODID);
    }

    public static Object getValueMethod(String varName, String modID) {
        try {
            return getValue.invoke((Object)"berezka_api", modID + ":" + varName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("[The Lost City] variable: " + varName + " was not found");
            throw new RuntimeException(e);
        }
    }

    public static String getText(String key) {
        Map<String, String> selectedTranslations = translations.getOrDefault(language, enTranslations);
        return selectedTranslations.getOrDefault(key, key);
    }

    public static void addHouseToCity(String name) {
        loadedHouses.add(name);
    }

    public static void deleteHouseFromCity(String name) {
        loadedHouses.remove(name);
    }

    public static void replaceHouseFromCity(String _old, String _new) {
        if (loadedHouses.contains(_old)) {
            loadedHouses.remove(_old);
            loadedHouses.add(_new);
        }
    }

    public static void addBaseToCity(String name) {
        loadedBases.add(name);
    }

    public static void deleteBaseFromCity(String name) {
        loadedBases.remove(name);
    }

    public static void replaceBaseFromCity(String _old, String _new) {
        if (loadedBases.contains(_old)) {
            loadedBases.remove(_old);
            loadedBases.add(_new);
        }
    }

    public static void addUnderTileToCity(String name) {
        loadedUnderTiles.add(name);
    }

    public static void deleteUnderTileFromCity(String name) {
        loadedUnderTiles.remove(name);
    }

    public static void replaceUnderTileFromCity(String _old, String _new) {
        if (loadedUnderTiles.contains(_old)) {
            loadedUnderTiles.remove(_old);
            loadedUnderTiles.add(_new);
        }
    }

    public static void addCarToCity(String name) {
        loadedCars.add(name);
    }

    public static void deleteCarFromCity(String name) {
        disabledStructures.add(name);
    }

    public static void replaceCarFromCity(String _old, String _new) {
        if (loadedCars.contains(_old)) {
            loadedCars.remove(_old);
            loadedCars.add(_new);
        }
    }

    public static void replaceStructure(String oldName, String newName) {
        replacedStructures.put(oldName, newName);
    }

    public static void disableStructure(String name) {
        disabledStructures.add(name);
    }

    public boolean doOldPluginsDataExist() {
        String fullpath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + MODID;
        File directory = new File(fullpath);
        File[] files = directory.listFiles();
        if (debugMode) {
            assert (files != null);
            LOGGER.info("[The Lost City] loading old plugins from folder: " + fullpath + " directory exist: " + (files != null));
        }
        return files != null;
    }

    public static List<String> loadDataFromFiles(String directoryPath) {
        ArrayList<String> loadedData = new ArrayList<String>();
        File directory = new File(directoryPath);
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String structureName = jsonObject.get("structure_name").getAsString();
                    loadedData.add(structureName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return loadedData;
    }
}

