/*
 * Decompiled with CFR 0.152.
 */
package com.berezka.the_lost_city;

import com.berezka.the_lost_city.structures.CityStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class STStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"the_lost_city");
    public static final RegistryObject<Structure<NoFeatureConfig>> RUN_DOWN_HOUSE = DEFERRED_REGISTRY_STRUCTURE.register("lost_city", () -> new CityStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        STStructures.setupMapSpacingAndLand((Structure)RUN_DOWN_HOUSE.get(), new StructureSeparationSettings(34, 8, 1234567890), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

