/*
 * Decompiled with CFR 0.152.
 */
package com.berezka.the_lost_city;

import com.berezka.the_lost_city.STConfiguredStructures;
import com.berezka.the_lost_city.STStructures;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_lost_city")
public class StructureTutorialMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "the_lost_city";
    private static Method GETCODEC_METHOD;

    public StructureTutorialMain() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        STStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            STStructures.setupStructures();
            STConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().add(() -> STConfiguredStructures.CONFIGURED_RUN_DOWN_HOUSE);
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(STStructures.RUN_DOWN_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)STStructures.RUN_DOWN_HOUSE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

