/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.common.RuleWorld;

public class GameRules<W> {
    private final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(RuleWorld.class, (Object)new RuleWorldSerializer(this)).enableComplexMapKeySerialization().setPrettyPrinting().create();
    private final HashMap<W, RuleWorld<W>> worldsCache = new HashMap();

    public HashMap<W, RuleWorld<W>> worldsCache() {
        return this.worldsCache;
    }

    public RuleWorld<W> loadData(W world, HashMap<GameRule, Object> data) {
        RuleWorld<W> w = new RuleWorld<W>(world);
        w.loadData(data);
        this.worldsCache.put(world, w);
        return this.worldsCache.get(world);
    }

    public RuleWorld<W> loadDefaults(W world) {
        RuleWorld<W> w = new RuleWorld<W>(world);
        w.loadDefaults();
        this.worldsCache.put(world, w);
        return this.worldsCache.get(world);
    }

    public RuleWorld<W> serializeData(W world, File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
            this.gson.toJson(this.worldsCache.get(world), (Appendable)writer);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.worldsCache.remove(world);
    }

    public RuleWorld<W> deSerializeData(W world, File file) {
        if (!file.exists()) {
            return this.loadDefaults(world);
        }
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            this.worldsCache.put(world, (RuleWorld)this.gson.fromJson((Reader)reader, RuleWorld.class));
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.worldsCache.get(world);
    }

    public Object gameRuleValue(W world, GameRule gameRule) {
        return this.worldsCache.get(world).value(gameRule);
    }

    public Boolean gameRuleValueBool(W world, GameRule gameRule) {
        return this.worldsCache.get(world).valueBool(gameRule);
    }

    public Integer gameRuleValueInt(W world, GameRule gameRule) {
        return this.worldsCache.get(world).valueInt(gameRule);
    }

    public Float gameRuleValueFloat(W world, GameRule gameRule) {
        return this.worldsCache.get(world).valueFloat(gameRule);
    }

    public Double gameRuleValueDouble(W world, GameRule gameRule) {
        return this.worldsCache.get(world).valueDouble(gameRule);
    }

    public Object gameRuleValue(W world, GameRule gameRule, Object value) {
        this.worldsCache.get(world).value(gameRule, value);
        return value;
    }

    private class RuleWorldSerializer
    implements JsonSerializer<RuleWorld<W>>,
    JsonDeserializer<RuleWorld<W>> {
        private RuleWorldSerializer(GameRules gameRules) {
        }

        public RuleWorld<W> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonArray array = obj.get("rules").getAsJsonArray();
            RuleWorld world = new RuleWorld();
            HashMap<GameRule, Object> tempValues = new HashMap<GameRule, Object>();
            array.forEach(element -> {
                JsonObject ruleObj = element.getAsJsonObject();
                String gameRule = ruleObj.get("gameRule").getAsString();
                String valueType = ruleObj.get("valueType").getAsString();
                String value = ruleObj.get("value").getAsString();
                Object finalValue = value;
                if (valueType.contains("Boolean") || valueType.contains("boolean")) {
                    finalValue = Boolean.valueOf(value);
                } else if (valueType.contains("Integer") || valueType.contains("int")) {
                    finalValue = Integer.valueOf(value);
                } else if (valueType.contains("Double") || valueType.contains("double")) {
                    finalValue = Double.valueOf(value);
                } else if (valueType.contains("Float") || valueType.contains("float")) {
                    finalValue = Float.valueOf(value);
                }
                if (GameRule.fromId(gameRule) == null) {
                    return;
                }
                tempValues.put(GameRule.fromId(gameRule), finalValue);
            });
            world.loadData(tempValues);
            return world;
        }

        public JsonElement serialize(RuleWorld<W> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            JsonArray array = new JsonArray();
            src.values.forEach((rule, value) -> {
                JsonObject ruleObj = new JsonObject();
                ruleObj.add("gameRule", (JsonElement)new JsonPrimitive(rule.id()));
                ruleObj.add("valueType", (JsonElement)new JsonPrimitive(value.getClass().getName()));
                ruleObj.add("value", (JsonElement)new JsonPrimitive(value.toString()));
                array.add((JsonElement)ruleObj);
            });
            obj.add("rules", (JsonElement)array);
            return obj;
        }
    }
}

