/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.common;

import java.util.HashMap;
import java.util.stream.Stream;
import me.gamerduck.rules.common.GameRule;

public class RuleWorld<W> {
    public HashMap<GameRule, Object> values = new HashMap();
    public W world;

    public RuleWorld(W world) {
        this.loadDefaults();
        this.world = world;
    }

    public RuleWorld() {
    }

    public W world(W world) {
        this.world = world;
        return this.world;
    }

    public W world() {
        return this.world;
    }

    public Object value(GameRule rule) {
        if (!this.values.containsKey((Object)rule)) {
            this.values.put(rule, rule.defaultValue());
        }
        return this.values.get((Object)rule);
    }

    public Boolean valueBool(GameRule rule) {
        return (Boolean)this.value(rule);
    }

    public Integer valueInt(GameRule rule) {
        return (Integer)this.value(rule);
    }

    public Double valueDouble(GameRule rule) {
        return (Double)this.value(rule);
    }

    public Float valueFloat(GameRule rule) {
        return (Float)this.value(rule);
    }

    public void value(GameRule rule, Object value) {
        this.values.put(rule, value);
    }

    public void loadDefaults() {
        Stream.of(GameRule.values()).forEach(rule -> this.values.put((GameRule)((Object)rule), rule.defaultValue()));
    }

    public void loadData(HashMap<GameRule, Object> data) {
        this.values.putAll(data);
    }
}

