/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class Config {
    private static final Properties PROPS = new Properties();
    private static Path FILE;

    private Config() {
    }

    public static void load(Path file) {
        FILE = file;
        try {
            InputStream in;
            if (!Files.exists(FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(FILE, new LinkOption[0])) {
                in = Config.class.getClassLoader().getResourceAsStream("morerules.properties");
                try {
                    if (in == null) {
                        throw new FileNotFoundException("Default morerules.properties not found in JAR!");
                    }
                    Files.copy(in, FILE, new CopyOption[0]);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            in = Files.newInputStream(FILE, new OpenOption[0]);
            try {
                PROPS.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public static String get(String key) {
        return PROPS.getProperty(key);
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(Config.get(key));
    }

    public static int getInt(String key) {
        try {
            return Integer.parseInt(Config.get(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double getDouble(String key) {
        try {
            return Double.parseDouble(Config.get(key));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static void setDefault(String key, String value) {
        if (!PROPS.containsKey(key)) {
            PROPS.setProperty(key, value);
        }
    }
}

