/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.paper.behaviors;

import java.util.Optional;
import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.paper.MoreRules;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.World;

public class NoExplosionBehavior
extends ExplosionDamageCalculator {
    private final ExplosionDamageCalculator secondBehavior;
    private final GameRule breakBlocksRule;
    private final GameRule doDamageRule;
    private final World world;

    public NoExplosionBehavior(ExplosionDamageCalculator secondBehavior, World world, GameRule breakBlocksRule, GameRule doDamageRule) {
        this.secondBehavior = secondBehavior;
        this.world = world;
        this.breakBlocksRule = breakBlocksRule;
        this.doDamageRule = doDamageRule;
    }

    public NoExplosionBehavior(World world, GameRule breakBlocksRule, GameRule doDamageRule) {
        this.secondBehavior = null;
        this.world = world;
        this.breakBlocksRule = breakBlocksRule;
        this.doDamageRule = doDamageRule;
    }

    public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, FluidState fluid) {
        return MoreRules.gameRules.gameRuleValueBool(this.world, this.breakBlocksRule).booleanValue() ? (this.secondBehavior == null ? super.getBlockExplosionResistance(explosion, reader, pos, state, fluid) : this.secondBehavior.getBlockExplosionResistance(explosion, reader, pos, state, fluid)) : Optional.of(Float.valueOf(-1.0f));
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
        return this.secondBehavior == null ? MoreRules.gameRules.gameRuleValueBool(this.world, this.breakBlocksRule).booleanValue() : this.secondBehavior.shouldBlockExplode(explosion, reader, pos, state, power);
    }

    public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
        return this.doDamageRule == null || (this.secondBehavior == null ? MoreRules.gameRules.gameRuleValueBool(this.world, this.doDamageRule) != false : this.secondBehavior.shouldDamageEntity(explosion, entity));
    }
}

