/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.paper.events;

import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.paper.MoreRules;
import me.gamerduck.rules.paper.behaviors.NoExplosionBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionEvents
implements Listener {
    @EventHandler
    public void onExplosion(EntityExplodeEvent e) {
        CraftWorld craftWorld = (CraftWorld)e.getLocation().getWorld();
        ServerLevel world = craftWorld.getHandle();
        Entity entity = ((CraftEntity)e.getEntity()).getHandle();
        double x = e.getLocation().getX();
        double y = e.getLocation().getY();
        double z = e.getLocation().getZ();
        float yield = e.getYield();
        switch (e.getEntityType()) {
            case CREEPER: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.CREEPER_GRIEFING).booleanValue() && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.CREEPER_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.CREEPER_GRIEFING, GameRule.CREEPER_DAMAGE), x, y, z, yield, false, Level.ExplosionInteraction.MOB);
                break;
            }
            case TNT: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.TNT_GRIEFING).booleanValue() && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.TNT_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.TNT_GRIEFING, GameRule.TNT_DAMAGE), x, y, z, yield, false, Level.ExplosionInteraction.TNT);
                break;
            }
            case END_CRYSTAL: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.CRYSTAL_GRIEFING).booleanValue() && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.CRYSTAL_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.CRYSTAL_GRIEFING, GameRule.CRYSTAL_DAMAGE), x, y, z, yield, true, Level.ExplosionInteraction.STANDARD);
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                Projectile proj = (Projectile)e.getEntity();
                if ((!(proj.getShooter() instanceof Ghast) || MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.BED_GRIEFING).booleanValue()) && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.BED_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.GHAST_GRIEFING, GameRule.GHAST_DAMAGE), x, y, z, yield, true, Level.ExplosionInteraction.MOB);
                break;
            }
            case WITHER_SKULL: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.WITHER_SKULL_GRIEFING).booleanValue() && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.WITHER_SKULL_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.WITHER_SKULL_GRIEFING, GameRule.WITHER_SKULL_DAMAGE), x, y, z, yield, true, Level.ExplosionInteraction.STANDARD);
                break;
            }
            case WITHER: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.WITHER_GRIEFING).booleanValue() && MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.WITHER_DAMAGE).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.WITHER_GRIEFING, GameRule.WITHER_DAMAGE), x, y, z, yield, true, Level.ExplosionInteraction.STANDARD);
                break;
            }
            case ENDER_DRAGON: {
                if (MoreRules.gameRules.gameRuleValueBool((World)craftWorld, GameRule.DRAGON_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.explode(entity, Explosion.getDefaultDamageSource((Level)world, (Entity)entity), (ExplosionDamageCalculator)new NoExplosionBehavior((World)craftWorld, GameRule.DRAGON_GRIEFING, null), x, y, z, yield, true, Level.ExplosionInteraction.STANDARD);
            }
        }
    }

    @EventHandler
    public void onBlockExplosion(BlockExplodeEvent e) {
        ServerLevel world = ((CraftWorld)e.getBlock().getLocation().getWorld()).getHandle();
        double x = e.getBlock().getLocation().getX();
        double y = e.getBlock().getLocation().getY();
        double z = e.getBlock().getLocation().getZ();
        float yield = e.getYield();
        if (e.getBlock().getType().toString().contains("BED") && !MoreRules.gameRules.gameRuleValueBool(e.getBlock().getWorld(), GameRule.BED_GRIEFING).booleanValue() || !MoreRules.gameRules.gameRuleValueBool(e.getBlock().getWorld(), GameRule.BED_DAMAGE).booleanValue()) {
            e.setCancelled(true);
            world.explode(null, Explosion.getDefaultDamageSource((Level)world, null), (ExplosionDamageCalculator)new NoExplosionBehavior((World)world.getWorld(), GameRule.BED_GRIEFING, GameRule.BED_DAMAGE), x, y, z, yield, false, Level.ExplosionInteraction.STANDARD);
        } else if (e.getBlock().getType().equals((Object)Material.RESPAWN_ANCHOR) && !MoreRules.gameRules.gameRuleValueBool(e.getBlock().getWorld(), GameRule.RESPAWN_ANCHOR_GRIEFING).booleanValue() || !MoreRules.gameRules.gameRuleValueBool(e.getBlock().getWorld(), GameRule.RESPAWN_ANCHOR_DAMAGE).booleanValue()) {
            e.setCancelled(true);
            world.explode(null, Explosion.getDefaultDamageSource((Level)world, null), (ExplosionDamageCalculator)new NoExplosionBehavior((World)world.getWorld(), GameRule.RESPAWN_ANCHOR_GRIEFING, GameRule.RESPAWN_ANCHOR_DAMAGE), x, y, z, yield, false, Level.ExplosionInteraction.STANDARD);
        }
    }
}

