/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.bukkit.events;

import me.gamerduck.rules.bukkit.MoreRules;
import me.gamerduck.rules.common.GameRule;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntityEvents
implements Listener {
    @EventHandler
    public void onSlimeSplitEvent(SlimeSplitEvent e) {
        if (!MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SLIMES_SPLIT).booleanValue()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent e) {
        if (e.getEntityType() == EntityType.ENDERMAN) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ENDERMEN_GRIEFING) == false);
        }
        if (e.getEntityType() == EntityType.SILVERFISH) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SILVERFISH_INFEST) == false);
        }
    }

    @EventHandler
    public void onEntityConvert(EntityTransformEvent e) {
        if (e.getEntityType() == EntityType.PIG && e.getTransformedEntity().getType() == EntityType.ZOMBIFIED_PIGLIN) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PIG_PIGLIN_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.ZOMBIE_VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_ZOMBIE_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.ZOMBIE_VILLAGER && e.getTransformedEntity().getType() == EntityType.VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ZOMBIE_VILLAGER_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.WITCH) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_WITCH_CONVERSIONS) == false);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        if (e.getEntity() instanceof Player || e.getEntity() instanceof Villager) {
            return;
        }
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.MOB_PICKUP) == false);
    }
}

