/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.paper.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.Stream;
import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.paper.MoreRules;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;

public class GameRuleCommand {
    public static void inject() {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.literal((String)"gamerule").requires(wrapper -> wrapper.hasPermission(2));
        Stream.of(GameRule.values()).forEach(rule -> {
            RequiredArgumentBuilder type = Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool());
            argumentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)rule.id()).executes(commandContext -> GameRuleCommand.executeQuery((CommandContext<CommandSourceStack>)commandContext, rule))).then(type.executes(commandContext -> GameRuleCommand.executeSet((CommandContext<CommandSourceStack>)commandContext, rule))));
        });
        MinecraftServer.getServer().getCommands().getDispatcher().register(argumentBuilder);
    }

    private static int executeSet(CommandContext<CommandSourceStack> commandContext, GameRule rule) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        MoreRules.gameRules.gameRuleValue(source.getBukkitEntity().getWorld(), rule, commandContext.getArgument("value", rule.type()));
        source.getBukkitEntity().sendMessage((Component)Component.text((String)String.format("Gamerule %s is now set to: %s", rule.id(), MoreRules.gameRules.gameRuleValue(source.getBukkitEntity().getWorld(), rule))));
        return 1;
    }

    private static int executeQuery(CommandContext<CommandSourceStack> commandContext, GameRule rule) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        source.getBukkitEntity().sendMessage((Component)Component.text((String)String.format("Gamerule %s is currently set to: %s", rule.id(), MoreRules.gameRules.gameRuleValue(source.getBukkitEntity().getWorld(), rule))));
        return 1;
    }
}

