/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.bukkit.events;

import me.gamerduck.rules.bukkit.MoreRules;
import me.gamerduck.rules.common.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionEvents
implements Listener {
    @EventHandler
    public void onExplosionDamage(EntityDamageEvent e) {
        World world = e.getEntity().getWorld();
        if (e.getDamageSource().getCausingEntity() != null && (e.getDamageSource().getDamageType() == DamageType.PLAYER_EXPLOSION || e.getDamageSource().getDamageType() == DamageType.EXPLOSION)) {
            e.setCancelled(switch (e.getDamageSource().getCausingEntity().getType()) {
                case EntityType.CREEPER -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.CREEPER_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.TNT -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.TNT_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.END_CRYSTAL -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.CRYSTAL_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.FIREBALL, EntityType.SMALL_FIREBALL -> {
                    Projectile proj = (Projectile)e.getEntity();
                    if (proj.getShooter() instanceof Ghast) {
                        if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.GHAST_DAMAGE).booleanValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    yield e.isCancelled();
                }
                case EntityType.WITHER_SKULL -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.WITHER_SKULL_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.WITHER -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.WITHER_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.SQUID -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.BED_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case EntityType.GLOW_SQUID -> {
                    if (!MoreRules.gameRules.gameRuleValueBool(world, GameRule.RESPAWN_ANCHOR_DAMAGE).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                default -> e.isCancelled();
            });
        }
    }

    @EventHandler
    public void onExplosion(EntityExplodeEvent e) {
        World world = e.getLocation().getWorld();
        double x = e.getLocation().getX();
        double y = e.getLocation().getY();
        double z = e.getLocation().getZ();
        switch (e.getEntityType()) {
            case CREEPER: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.CREEPER_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                Creeper entity = (Creeper)e.getEntity();
                world.createExplosion(x, y, z, entity.isPowered() ? 6.0f : 3.0f, false, false, e.getEntity());
                break;
            }
            case TNT: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.TNT_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 4.0f, false, false, e.getEntity());
                break;
            }
            case END_CRYSTAL: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.CRYSTAL_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 6.0f, false, false, e.getEntity());
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                Projectile proj = (Projectile)e.getEntity();
                if (!(proj.getShooter() instanceof Ghast) || MoreRules.gameRules.gameRuleValueBool(world, GameRule.GHAST_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 1.0f, false, false, e.getEntity());
                break;
            }
            case WITHER_SKULL: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.WITHER_SKULL_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 1.0f, false, false, e.getEntity());
                break;
            }
            case WITHER: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.WITHER_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 7.0f, false, false, e.getEntity());
                break;
            }
            case ENDER_DRAGON: {
                if (MoreRules.gameRules.gameRuleValueBool(world, GameRule.DRAGON_GRIEFING).booleanValue()) break;
                e.setCancelled(true);
                world.createExplosion(x, y, z, 1.0f, false, false, e.getEntity());
            }
        }
    }

    @EventHandler
    public void onBlockExplosionDamage(EntityDamageByBlockEvent e) {
        if (e.getDamageSource().getDamageType().equals((Object)DamageType.BAD_RESPAWN_POINT)) {
            if (e.getEntity().getWorld().isPiglinSafe() && !MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.BED_DAMAGE).booleanValue()) {
                e.setCancelled(true);
            } else if (!e.getEntity().getWorld().isPiglinSafe() && !MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.RESPAWN_ANCHOR_DAMAGE).booleanValue()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockExplosion(BlockExplodeEvent e) {
        World world = e.getBlock().getLocation().getWorld();
        double x = e.getBlock().getLocation().getX();
        double y = e.getBlock().getLocation().getY();
        double z = e.getBlock().getLocation().getZ();
        if (world.isPiglinSafe() && !MoreRules.gameRules.gameRuleValueBool(world, GameRule.BED_GRIEFING).booleanValue()) {
            e.setCancelled(true);
            Location entLoc = e.getBlock().getLocation().clone();
            entLoc.setY(300.0);
            Entity ent = world.spawnEntity(entLoc, EntityType.SQUID);
            world.createExplosion(x, y, z, 5.0f, true, false, ent);
            ent.remove();
        } else if (!world.isPiglinSafe() && !MoreRules.gameRules.gameRuleValueBool(world, GameRule.RESPAWN_ANCHOR_GRIEFING).booleanValue()) {
            e.setCancelled(true);
            Location entLoc = e.getBlock().getLocation().clone();
            entLoc.setY(300.0);
            Entity ent = world.spawnEntity(entLoc, EntityType.GLOW_SQUID);
            world.createExplosion(x, y, z, 5.0f, false, false, ent);
            ent.remove();
        }
    }
}

