/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.bukkit.events;

import me.gamerduck.rules.bukkit.MoreRules;
import me.gamerduck.rules.common.GameRule;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerBowEvents
implements Listener {
    private final JavaPlugin plugin;

    public PlayerBowEvents(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBowUse(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack bow = e.getItem();
            if (bow == null || bow.getType() != Material.BOW) {
                return;
            }
            if (bow.containsEnchantment(Enchantment.INFINITY) && !MoreRules.gameRules.gameRuleValueBool(e.getPlayer().getWorld(), GameRule.INFINITY_NEED_ARROW).booleanValue() && !player.getInventory().contains(Material.ARROW)) {
                ItemStack fakeArrow = new ItemStack(Material.ARROW);
                ItemMeta meta = fakeArrow.getItemMeta();
                meta.setDisplayName("\u00a77[Fake Infinity Arrow]");
                fakeArrow.setItemMeta(meta);
                player.getInventory().addItem(new ItemStack[]{fakeArrow});
            }
        }
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player) || MoreRules.gameRules.gameRuleValueBool((player = (Player)livingEntity).getWorld(), GameRule.INFINITY_NEED_ARROW).booleanValue()) {
            return;
        }
        ItemStack bow = e.getBow();
        if (bow == null) {
            return;
        }
        if (!bow.containsEnchantment(Enchantment.INFINITY)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.removeFakeArrow(player), 1L);
    }

    @EventHandler
    public void onItemSwitch(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        ItemStack oldItem = player.getInventory().getItem(e.getPreviousSlot());
        if (!MoreRules.gameRules.gameRuleValueBool(player.getWorld(), GameRule.INFINITY_NEED_ARROW).booleanValue() && oldItem != null && oldItem.getType() == Material.BOW && oldItem.containsEnchantment(Enchantment.INFINITY)) {
            this.removeFakeArrow(player);
        }
    }

    @EventHandler
    public void onItemSwitch(PlayerDropItemEvent e) {
        ItemStack droppedItem = e.getItemDrop().getItemStack();
        if (!MoreRules.gameRules.gameRuleValueBool(e.getPlayer().getWorld(), GameRule.INFINITY_NEED_ARROW).booleanValue() && droppedItem != null && droppedItem.getType() == Material.BOW && droppedItem.containsEnchantment(Enchantment.INFINITY)) {
            this.removeFakeArrow(e.getPlayer());
        }
    }

    private void removeFakeArrow(Player player) {
        PlayerInventory inv = player.getInventory();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getType() != Material.ARROW || !item.hasItemMeta() || !"\u00a77[Fake Infinity Arrow]".equals(item.getItemMeta().getDisplayName())) continue;
            inv.clear(i);
            break;
        }
    }
}

