/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.bukkit;

import java.io.File;
import java.nio.file.Paths;
import me.gamerduck.rules.bukkit.commands.GameRuleCommand;
import me.gamerduck.rules.bukkit.commands.GameRuleCompletions;
import me.gamerduck.rules.bukkit.commodore.Commodore;
import me.gamerduck.rules.bukkit.commodore.CommodoreProvider;
import me.gamerduck.rules.bukkit.events.BlockChangeEvents;
import me.gamerduck.rules.bukkit.events.EntityEvents;
import me.gamerduck.rules.bukkit.events.ExplosionEvents;
import me.gamerduck.rules.common.GameRules;
import me.gamerduck.rules.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MoreRules
extends JavaPlugin
implements Listener {
    public static GameRules<World> gameRules;

    public void onEnable() {
        gameRules = new GameRules();
        Config.load(Paths.get("plugins/MoreRules/morerules.properties", new String[0]));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ExplosionEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockChangeEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityEvents(), (Plugin)this);
        PluginCommand cmd = this.getCommand("gamerule");
        cmd.setExecutor((CommandExecutor)new GameRuleCommand());
        if (CommodoreProvider.isSupported()) {
            Commodore commodore = CommodoreProvider.getCommodore((Plugin)this);
            GameRuleCompletions.register(commodore, cmd);
        }
        Bukkit.getWorlds().forEach(w -> gameRules.deSerializeData((World)w, new File(Config.get("storage-path"), w.getUID().toString() + ".json")));
    }

    public void onDisable() {
        Bukkit.getWorlds().forEach(w -> gameRules.serializeData((World)w, new File(Config.get("storage-path"), w.getUID().toString() + ".json")));
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent e) {
        gameRules.deSerializeData(e.getWorld(), new File(Config.get("storage-path"), e.getWorld().getUID().toString() + ".json"));
    }

    @EventHandler
    public void onWorldUnLoad(WorldUnloadEvent e) {
        gameRules.serializeData(e.getWorld(), new File(Config.get("storage-path"), e.getWorld().getUID().toString() + ".json"));
    }
}

