/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.mixin.mixins;

import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.mixin.MixinsVariable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements Attackable,
WaypointTransmitter {
    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"onItemPickup"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject(ItemEntity itemEntity, CallbackInfo ci) {
        if (!this.getType().equals(EntityType.PLAYER) && !MixinsVariable.gameRules.gameRuleValueBool(this.level(), GameRule.MOB_PICKUP).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectHurtServer(ServerLevel level, DamageSource source, float p_376610_, CallbackInfoReturnable<Boolean> cir) {
        if (this.getType().equals(EntityType.PLAYER)) {
            if ((source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.IN_FIRE)) && !MixinsVariable.gameRules.gameRuleValueBool((Level)level, GameRule.FIRE_DAMAGE).booleanValue()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
            if (source.is(DamageTypes.ENDER_PEARL) && !MixinsVariable.gameRules.gameRuleValueBool((Level)level, GameRule.ENDER_PEARL_DAMAGE).booleanValue()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
            if (source.is(DamageTypes.FALL) && !MixinsVariable.gameRules.gameRuleValueBool((Level)level, GameRule.PLAYER_FALL_DAMAGE).booleanValue()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
            if (source.is(DamageTypes.DROWN) && !MixinsVariable.gameRules.gameRuleValueBool((Level)level, GameRule.PLAYER_DROWN).booleanValue()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        } else {
            LivingEntity livingEntity = (LivingEntity)this;
            if (livingEntity instanceof TamableAnimal) {
                TamableAnimal tamed = (TamableAnimal)livingEntity;
                if (!MixinsVariable.gameRules.gameRuleValueBool((Level)level, GameRule.PET_FRIENDLY_FIRE).booleanValue() && tamed.isTame() && tamed.getOwner() != null && source.getEntity() != null && tamed.getOwner().getUUID().equals(source.getEntity().getUUID())) {
                    cir.setReturnValue((Object)false);
                    cir.cancel();
                }
            }
        }
    }
}

