/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.bukkit.events;

import java.util.concurrent.ThreadLocalRandom;
import me.gamerduck.rules.bukkit.MoreRules;
import me.gamerduck.rules.common.GameRule;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class EntityEvents
implements Listener {
    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent e) {
        if (e.getEntityType() == EntityType.PHANTOM) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.DRAGON_DAMAGE) == false);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.getEntityType() == EntityType.PLAYER) {
            if (e.getDamageSource().getDamageType() == DamageType.FALL) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYER_FALL_DAMAGE) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.DROWN) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYER_DROWN) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.IN_FIRE || e.getDamageSource().getDamageType() == DamageType.ON_FIRE) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.FIRE_DAMAGE) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.ENDER_PEARL) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ENDER_PEARL_DAMAGE) == false);
            }
            if (e.getEntityType() == EntityType.ENDER_DRAGON) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.DRAGON_DAMAGE) == false);
            }
        } else {
            Tameable tamed;
            Entity entity = e.getEntity();
            if (entity instanceof Tameable && (tamed = (Tameable)entity).isTamed() && tamed.getOwner().getUniqueId() == e.getEntity().getUniqueId()) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PET_FRIENDLY_FIRE) == false);
            }
        }
    }

    @EventHandler
    public void onSlimeSplitEvent(SlimeSplitEvent e) {
        if (!MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SLIMES_SPLIT).booleanValue()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityEnterBlockEvent(EntityEnterBlockEvent e) {
        if (e.getEntityType() == EntityType.SILVERFISH) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SILVERFISH_INFEST) == false);
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent e) {
        if (e.getEntityType() == EntityType.ENDERMAN) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ENDERMEN_GRIEFING) == false);
        }
    }

    @EventHandler
    public void onEntityConvert(EntityTransformEvent e) {
        if (e.getEntityType() == EntityType.PIG && e.getTransformedEntity().getType() == EntityType.ZOMBIFIED_PIGLIN) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PIG_PIGLIN_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.ZOMBIE_VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_ZOMBIE_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.ZOMBIE_VILLAGER && e.getTransformedEntity().getType() == EntityType.VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ZOMBIE_VILLAGER_CONVERSIONS) == false);
        } else if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.WITCH) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_WITCH_CONVERSIONS) == false);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        if (e.getEntity() instanceof Player || e.getEntity() instanceof Villager) {
            return;
        }
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.MOB_PICKUP) == false);
    }

    @EventHandler
    public void onPickupArrow(PlayerPickupArrowEvent e) {
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getPlayer().getWorld(), GameRule.PROJECTILE_PICKUP) == false);
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYER_HUNGER) == false);
    }

    @EventHandler
    public void onDespawn(ItemDespawnEvent e) {
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ITEMS_DESPAWN) == false);
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        if (e.getEntity() instanceof Player) {
            return;
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Double chance;
        if (MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYERS_HEAD_DROP).booleanValue() && ((chance = MoreRules.gameRules.gameRuleValueDouble(e.getEntity().getWorld(), GameRule.PLAYERS_HEAD_DROP_CHANCE)) < 0.0 || chance >= ThreadLocalRandom.current().nextDouble(0.0, 100.0))) {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)e.getEntity());
            head.setItemMeta((ItemMeta)meta);
            e.getDrops().add(head);
        }
    }

    @EventHandler
    public void EnderDragonDying(EnderDragonChangePhaseEvent e) {
        if (e.getNewPhase() == EnderDragon.Phase.DYING && e.getEntity().getDragonBattle() != null && e.getEntity().getDragonBattle().hasBeenPreviouslyKilled() && MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.NEW_DRAGON_EGGS).booleanValue()) {
            e.getEntity().getWorld().getBlockAt(0, e.getEntity().getWorld().getHighestBlockYAt(0, 0) + 1, 0).setType(Material.DRAGON_EGG);
        }
    }
}

