/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.paper;

import java.io.File;
import java.nio.file.Paths;
import me.gamerduck.rules.common.GameRules;
import me.gamerduck.rules.config.Config;
import me.gamerduck.rules.paper.commands.GameRuleCommand;
import me.gamerduck.rules.paper.events.BlockChangeEvents;
import me.gamerduck.rules.paper.events.EntityEvents;
import me.gamerduck.rules.paper.events.ExplosionEvents;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MoreRules
extends JavaPlugin
implements Listener {
    public static GameRules<World> gameRules;

    public MoreRules() {
        gameRules = new GameRules();
        Config.load(Paths.get("plugins/MoreRules/morerules.properties", new String[0]));
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ExplosionEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockChangeEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityEvents(), (Plugin)this);
        GameRuleCommand.inject();
        Bukkit.getWorlds().forEach(w -> gameRules.deSerializeData((World)w, new File(Config.get("storage-path"), w.getUID().toString() + ".json")));
    }

    public void onDisable() {
        Bukkit.getWorlds().forEach(w -> gameRules.serializeData((World)w, new File(Config.get("storage-path"), w.getUID().toString() + ".json")));
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent e) {
        gameRules.deSerializeData(e.getWorld(), new File(Config.get("storage-path"), e.getWorld().getUID().toString() + ".json"));
    }

    @EventHandler
    public void onWorldUnLoad(WorldUnloadEvent e) {
        gameRules.serializeData(e.getWorld(), new File(Config.get("storage-path"), e.getWorld().getUID().toString() + ".json"));
    }
}

