/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.rules.paper.events;

import me.gamerduck.rules.common.GameRule;
import me.gamerduck.rules.paper.MoreRules;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Silverfish;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntityEvents
implements Listener {
    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent e) {
        if (e.getEntityType() == EntityType.PHANTOM) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.DRAGON_DAMAGE) == false);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.getEntityType() == EntityType.PLAYER) {
            if (e.getDamageSource().getDamageType() == DamageType.FALL) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYER_FALL_DAMAGE) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.DROWN) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PLAYER_DROWN) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.IN_FIRE || e.getDamageSource().getDamageType() == DamageType.ON_FIRE) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.FIRE_DAMAGE) == false);
            }
            if (e.getDamageSource().getDamageType() == DamageType.ENDER_PEARL) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ENDER_PEARL_DAMAGE) == false);
            }
            if (e.getEntityType() == EntityType.ENDER_DRAGON) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.DRAGON_DAMAGE) == false);
            }
        } else {
            Tameable tamed;
            Entity entity = e.getEntity();
            if (entity instanceof Tameable && (tamed = (Tameable)entity).isTamed() && tamed.getOwner().getUniqueId() == e.getEntity().getUniqueId()) {
                e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PET_FRIENDLY_FIRE) == false);
            }
        }
    }

    @EventHandler
    public void onSlimeSplitEvent(SlimeSplitEvent e) {
        if (!MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SLIMES_SPLIT).booleanValue()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityEnterBlockEvent(EntityEnterBlockEvent e) {
        if (e.getEntity() instanceof Silverfish) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.SILVERFISH_INFEST) == false);
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent e) {
        if (e.getEntity() instanceof EnderMan) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ENDERMEN_GRIEFING) == false);
        }
    }

    @EventHandler
    public void onEntityConvert(EntityTransformEvent e) {
        if (e.getEntityType() == EntityType.PIG && e.getTransformedEntity().getType() == EntityType.ZOMBIFIED_PIGLIN) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.PIG_PIGLIN_CONVERSIONS) == false);
        }
        if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.ZOMBIE_VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_ZOMBIE_CONVERSIONS) == false);
        }
        if (e.getEntityType() == EntityType.ZOMBIE_VILLAGER && e.getTransformedEntity().getType() == EntityType.VILLAGER) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.ZOMBIE_VILLAGER_CONVERSIONS) == false);
        }
        if (e.getEntityType() == EntityType.VILLAGER && e.getTransformedEntity().getType() == EntityType.WITCH) {
            e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.VILLAGER_WITCH_CONVERSIONS) == false);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        if (e.getEntity() instanceof Player || e.getEntity() instanceof Villager) {
            return;
        }
        e.setCancelled(MoreRules.gameRules.gameRuleValueBool(e.getEntity().getWorld(), GameRule.MOB_PICKUP) == false);
    }
}

