/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.Map;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ColorableVivicusBlock
extends Colorable {
    default public EnumProperty<DyeColor> getColorProperty() {
        return ModStateProperties.COLOR;
    }

    default public void addDye(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!blockState.hasProperty(this.getColorProperty())) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Dye dye = Dye.getDyeFromDyespria(stack);
        RandomSource randomSource = level.random;
        if (((DyeColor)blockState.getValue(this.getColorProperty())).equals((Object)dye.color()) || dye.isEmpty()) {
            return;
        }
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(this.getColorProperty(), (Comparable)dye.color()));
        ItemStack itemStack = Dye.stackFromDye(new Dye(dye.color(), dye.amount() - randomSource.nextIntBetweenInclusive(0, 1)));
        Dye.setDyeToDyeHolderStack(stack, itemStack, itemStack.getCount());
        if (!level.isClientSide()) {
            this.particles(randomSource, (Level)((ServerLevel)level), dye, blockPos);
        }
    }

    default public int getColorId(BlockPlaceContext context) {
        return (Integer)context.getItemInHand().getOrDefault(ModDataComponents.COLOR_ID, (Object)0);
    }

    @Nullable
    default public BlockState stateForPlacementHelper(BlockState state, BlockPlaceContext context) {
        if (state != null) {
            return (BlockState)state.setValue(ModStateProperties.COLOR, (Comparable)DyeColor.byId((int)this.getColorId(context)));
        }
        return null;
    }

    @NotNull
    default public ItemStack cloneItemStackHelper(BlockState state, ItemStack stack) {
        int colorId = ((DyeColor)state.getValue(ModStateProperties.COLOR)).getId();
        int color = this.colorValues().get(DyeColor.byId((int)colorId));
        stack.set(ModDataComponents.COLOR, (Object)color);
        stack.set(ModDataComponents.COLOR_ID, (Object)colorId);
        return stack;
    }

    @Override
    default public Map<DyeColor, Integer> colorValues() {
        Map<DyeColor, Integer> map = Colorable.super.colorValues();
        map.put(DyeColor.WHITE, -1);
        map.put(DyeColor.LIGHT_GRAY, -2962728);
        map.put(DyeColor.GRAY, -5200706);
        map.put(DyeColor.BLACK, -8159589);
        map.put(DyeColor.BROWN, -2710916);
        map.put(DyeColor.RED, -21338);
        map.put(DyeColor.ORANGE, -11904);
        map.put(DyeColor.YELLOW, -3974);
        map.put(DyeColor.LIME, -2228329);
        map.put(DyeColor.GREEN, -6094926);
        map.put(DyeColor.CYAN, -6553638);
        map.put(DyeColor.LIGHT_BLUE, -4259846);
        map.put(DyeColor.BLUE, -5779969);
        map.put(DyeColor.PURPLE, -3362561);
        map.put(DyeColor.MAGENTA, -1462785);
        map.put(DyeColor.PINK, -10249);
        return map;
    }
}

