/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.SaltemoneBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.multiblock.ICorruptableMultiblock;
import net.abraxator.moresnifferflowers.entities.SaltBubbleProjectile;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.networking.toClient.SaltemoneParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;

public class SaltemoneBlock
extends AbstractMultiBlock
implements EntityBlock,
Corruptable,
ModCropBlock,
IPreviewableMultiblock,
ICorruptableMultiblock {
    protected static final VoxelShape AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SaltemoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    public void createSyncedBlockStates(SyncedStatePropertiesBuilder builder) {
        super.createSyncedBlockStates(builder);
        builder.add((Property)ModStateProperties.SHEARED);
        builder.add((Property)this.getAgeProperty());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getAgeProperty(), ModStateProperties.SHEARED});
    }

    public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return !level.isWaterAt(pos) && level.isWaterAt(pos.below());
    }

    @Nullable
    public DirectionProperty getDirectionProperty() {
        return HorizontalDirectionalBlock.FACING;
    }

    public BlockState getDefaultStateForPreviews(Direction direction) {
        return (BlockState)super.getDefaultStateForPreviews(direction).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (!IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.INVISIBLE;
        }
        if (this.getAge(state) == this.getMaxAge()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public List<BlockPos> makeFullBlockShape(Direction direction, BlockPos center, BlockState blockState) {
        BlockPos relative = center.relative(direction).relative(direction.getClockWise());
        return IMultiBlock.posStreamToList((Stream)BlockPos.betweenClosedStream((BlockPos)center, (BlockPos)relative));
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return !this.isMaxAge(blockState);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }

    public boolean isCorrupted() {
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        SaltemoneBlockEntity entity;
        if (((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SaltemoneBlockEntity && pos.equals((Object)(entity = (SaltemoneBlockEntity)blockEntity).getCenter())) {
            if (this.isMaxAge(state)) {
                Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
                Vec3 vec3 = entity.getCenter().getCenter().relative(direction, 0.5).relative(direction.getClockWise(), 0.5).relative(Direction.UP, 0.0);
                float speed = 0.2f;
                SaltBubbleProjectile projectile = new SaltBubbleProjectile(vec3.x, vec3.y, vec3.z, (Level)level);
                projectile.setNoGravity(true);
                projectile.setCorrupted(this.isCorrupted());
                projectile.setState(0);
                projectile.setDeltaMovement(((double)random.nextFloat() - 0.5) * (double)speed, 1.0f * speed, ((double)random.nextFloat() - 0.5) * (double)speed);
                level.addFreshEntity((Entity)projectile);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SaltemoneParticlePacket(vec3.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (IMultiBlock.isCenter((BlockState)state)) {
                this.performBonemeal(level, random, pos, state);
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityinside) {
        this.corruptionHelper(state, level, pos, entityinside);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SaltemoneBlockEntity(blockPos, blockState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Override
    public Block getCuredBlock() {
        return (Block)ModBlocks.SALTEMONE.get();
    }

    @Override
    public Block getCorruptedBlock() {
        return (Block)ModBlocks.SOURLEMONE.get();
    }
}

