/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.corrupted;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModStatePropertiesUnsafe;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptionParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorruptedGrassBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public static final MapCodec<GrassBlock> CODEC = CorruptedGrassBlock.simpleCodec(GrassBlock::new);

    public MapCodec<GrassBlock> codec() {
        return CODEC;
    }

    public CorruptedGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ModStateProperties.CROWDED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isValidBonemealTarget(LevelReader p_256229_, BlockPos p_256432_, BlockState p_255677_) {
        return p_256229_.getBlockState(p_256432_.above()).isAir();
    }

    public boolean isBonemealSuccess(Level p_221275_, RandomSource p_221276_, BlockPos p_221277_, BlockState p_221278_) {
        return true;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity pEntity) {
        double d0 = Math.abs(pEntity.getDeltaMovement().y);
        if (d0 < 0.1 && !pEntity.isSteppingCarefully()) {
            double d1 = 0.8;
            pEntity.setDeltaMovement(pEntity.getDeltaMovement().multiply(d1, 1.0, d1));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModStateProperties.CROWDED});
    }

    public void performBonemeal(ServerLevel p_221270_, RandomSource p_221271_, BlockPos p_221272_, BlockState p_221273_) {
        BlockPos blockpos = p_221272_.above();
        BlockState blockstate = Blocks.SHORT_GRASS.defaultBlockState();
        Optional optional = p_221270_.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!p_221270_.getBlockState((blockpos1 = blockpos1.offset(p_221271_.nextInt(3) - 1, (p_221271_.nextInt(3) - 1) * p_221271_.nextInt(3) / 2, p_221271_.nextInt(3) - 1)).below()).is((Block)this) || p_221270_.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)p_221270_, blockpos1)) continue block0;
            }
            BlockState blockstate1 = p_221270_.getBlockState(blockpos1);
            if (blockstate1.is(blockstate.getBlock()) && p_221271_.nextInt(10) == 0) {
                ((BonemealableBlock)blockstate.getBlock()).performBonemeal(p_221270_, p_221271_, blockpos1, blockstate1);
            }
            if (!blockstate1.isAir()) continue;
            if (p_221271_.nextInt(8) == 0) {
                List list = ((Biome)p_221270_.getBiome(blockpos1).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).config()).feature();
            } else {
                if (!optional.isPresent()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.value()).place((WorldGenLevel)p_221270_, p_221270_.getChunkSource().getGenerator(), p_221271_, blockpos1);
        }
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)levelReader, blockpos));
        return i < levelReader.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return CorruptedGrassBlock.canBeGrass(state, level, pos) && !level.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        LevelChunk chunk = level.getChunkAt(pos);
        CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION);
        if (cap.count > 0) {
            --cap.count;
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CorruptedGrassBlock.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.setBlockAndUpdate(pos, Blocks.COARSE_DIRT.defaultBlockState());
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (((Boolean)state.getValue((Property)ModStateProperties.CROWDED)).booleanValue()) {
                return;
            }
            if (level.getMaxLocalRawBrightness(pos.above()) <= 6 && random.nextDouble() < 0.2 * (Double)ModServerConfig.CORRUPTION_SPREAD_SPEED.get()) {
                BlockState blockstate = this.defaultBlockState();
                boolean spreadSuccess = false;
                for (int i = 0; i < 4 && !spreadSuccess; ++i) {
                    spreadSuccess = CorruptedGrassBlock.spread(level, pos, random, blockstate);
                }
                CorruptedGrassBlock.placeCorruptedLeaves(level, pos, random);
                CorruptedGrassBlock.placeTallGrass(level, pos);
            }
        }
    }

    private static void placeCorruptedLeaves(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockPos1 = pos.above(random.nextInt(6));
        BlockState state2 = level.getBlockState(blockPos1);
        if (state2.getOptionalValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED).isPresent() && ((Boolean)state2.getValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED)).booleanValue()) {
            level.setBlock(blockPos1, (BlockState)state2.setValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private static boolean spread(ServerLevel level, BlockPos pos, RandomSource random, BlockState blockstate) {
        boolean canSpread;
        BlockPos pos1 = pos.offset(random.nextIntBetweenInclusive(-2, 2), random.nextIntBetweenInclusive(-2, 2), random.nextIntBetweenInclusive(-2, 2));
        BlockState state1 = level.getBlockState(pos1);
        boolean bl = canSpread = state1.is(BlockTags.DIRT) && CorruptedGrassBlock.canPropagate(blockstate, (LevelReader)level, pos1) && !state1.is((Block)ModBlocks.CURED_GRASS_BLOCK.get()) && !state1.is((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get());
        if (canSpread) {
            if (level.isClientSide) {
                return false;
            }
            if (CorruptedGrassBlock.checkChunks(level, pos, random, blockstate, pos1)) {
                return false;
            }
            level.setBlockAndUpdate(pos1, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(pos1.above()).is(Blocks.SNOW))));
            BlockPos posAbove = pos1.above();
            if (random.nextFloat() < 0.1f && level.getBlockState(posAbove).isAir()) {
                level.setBlock(posAbove, ((Block)ModBlocks.CORRUPTED_WART.get()).defaultBlockState(), 3);
            }
            return true;
        }
        return false;
    }

    private static boolean checkChunks(ServerLevel level, BlockPos pos, RandomSource random, BlockState blockstate, BlockPos pos1) {
        LevelChunk chunkNew = level.getChunkAt(pos1);
        LevelChunk chunkOriginal = level.getChunkAt(pos);
        CorruptionCapability capNew = CorruptionCapability.get(chunkNew);
        CorruptionCapability capOriginal = CorruptionCapability.get(chunkOriginal);
        boolean differentChunk = CorruptionCapability.areDifferentChunks((Level)level, pos1, pos);
        boolean isSourceOriginal = capOriginal.isSource;
        boolean isSourceNew = capNew.isSource;
        boolean isNeighborNew = capNew.isNeighbor;
        int count = capNew.count;
        int resistance = capNew.resistance;
        if (differentChunk) {
            if (isSourceOriginal) {
                ((CorruptionCapability)chunkNew.getData(ModDataAttachments.CHUNK_CORRUPTION)).isNeighbor = true;
            } else if (isNeighborNew) {
                return true;
            }
        }
        if (!isNeighborNew && !isSourceNew) {
            CorruptedGrassBlock.setCrowded(level, pos, blockstate, resistance, chunkOriginal);
            return true;
        }
        if (isNeighborNew && !isSourceNew) {
            int maxCorruption = 150;
            int maxResistance = 5;
            double chance = 1.0 - (double)count / (double)Math.max(maxCorruption - resistance * (maxCorruption / maxResistance), 1);
            if (chance <= 0.01) {
                CorruptedGrassBlock.setCrowded(level, pos, blockstate, resistance, chunkOriginal);
                return true;
            }
            if (random.nextDouble() > chance) {
                return true;
            }
        }
        ++capNew.count;
        return false;
    }

    private static void setCrowded(ServerLevel level, BlockPos pos, BlockState blockstate, int resistance, LevelChunk chunkOriginal) {
        level.setBlock(pos, (BlockState)blockstate.setValue((Property)ModStateProperties.CROWDED, (Comparable)Boolean.valueOf(true)), 3);
        boolean isPositive = resistance > 0;
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CorruptionParticlePacket(pos, isPositive, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (isPositive) {
            CorruptionCapability.sendFlowerParticles(chunkOriginal);
        }
    }

    private static void placeTallGrass(ServerLevel level, BlockPos pos) {
        if (level.getBlockState(pos.above()).is(Blocks.SHORT_GRASS)) {
            level.setBlock(pos.above(), ((Block)ModBlocks.CORRUPTED_GRASS.get()).defaultBlockState(), 18);
        }
        if (level.getBlockState(pos.above()).is(Blocks.TALL_GRASS)) {
            level.setBlock(pos.above(), (BlockState)((Block)ModBlocks.CORRUPTED_TALL_GRASS.get()).defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 18);
            level.setBlock(pos.above(2), (BlockState)((Block)ModBlocks.CORRUPTED_TALL_GRASS.get()).defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 18);
        }
    }
}

