/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ComboMealCapability {
    public static final Codec<ComboMealCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(ComboMealCapability::getSpeed), (App)Codec.INT.fieldOf("duration").forGetter(ComboMealCapability::getDuration)).apply((Applicative)instance, ComboMealCapability::new));
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("combo_meal");
    public float speed = 1.0f;
    public int duration = 0;

    public float getSpeed() {
        return this.speed;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public static ComboMealCapability getCapability(Player player) {
        return (ComboMealCapability)player.getData(ModDataAttachments.COMBO_MEAL.get());
    }

    public ComboMealCapability(float speed, int duration) {
        this.speed = speed;
        this.duration = duration;
    }

    public void onEffectEnd(Player player) {
        this.speed = 1.0f;
        this.duration = 0;
        player.getAttribute(Attributes.ATTACK_SPEED).removeModifier(ID);
    }

    public void onAttack(Player player, boolean isCharged) {
        int amplifier = Objects.requireNonNull(player.getEffect(ModEffects.COMBO_MEAL)).getAmplifier();
        if (isCharged) {
            this.speed *= 1.0f + ((float)amplifier / 4.0f + 1.0f) / 10.0f;
            this.duration = (int)(150.0f / (this.speed * 2.0f));
            player.getAttribute(Attributes.ATTACK_SPEED).removeModifier(ID);
            AttributeModifier mod = new AttributeModifier(ID, (double)(this.speed - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            player.getAttribute(Attributes.ATTACK_SPEED).addTransientModifier(mod);
        } else {
            this.duration /= 2;
        }
    }

    public void tick(Player player) {
        if (this.duration <= 0) {
            this.speed = 1.0f;
            player.getAttribute(Attributes.ATTACK_SPEED).removeModifier(ID);
        }
        if (this.duration > 0) {
            --this.duration;
        }
    }

    public void debugPrint() {
        System.out.println("lastSpeed: " + this.speed + " duration: " + this.duration);
    }
}

