/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptionParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorruptionCapability {
    public static final int MAX_RESISTANCE = 5;
    public static final int MAX_CORRUPTION = 150;
    public int count = 0;
    public boolean isSource = false;
    public boolean isNeighbor = false;
    public int resistance = 0;
    public HashSet<BlockPos> flowers = new HashSet();
    public static final Codec<CorruptionCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("count").forGetter(data -> data.count), (App)Codec.BOOL.fieldOf("isSource").forGetter(data -> data.isSource), (App)Codec.BOOL.fieldOf("isNeighbor").forGetter(data -> data.isNeighbor), (App)Codec.INT.fieldOf("resistance").forGetter(data -> data.resistance), (App)BlockPos.CODEC.listOf().fieldOf("flowers").xmap(HashSet::new, ArrayList::new).forGetter(data -> data.flowers)).apply((Applicative)instance, (count, isSource, isNeighbor, resistance, flowers) -> {
        CorruptionCapability data = new CorruptionCapability();
        data.count = count;
        data.isSource = isSource;
        data.isNeighbor = isNeighbor;
        data.resistance = resistance;
        data.flowers = flowers;
        return data;
    }));

    public static void sendFlowerParticles(LevelChunk chunk) {
        CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION.get());
        int count = 0;
        for (BlockPos pos : cap.flowers) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CorruptionParticlePacket(pos, true, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (++count < 5) continue;
            return;
        }
    }

    public static void onCorruptionSource(Level level, BlockPos pos) {
        LevelChunk chunk = level.getChunkAt(pos);
        CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION.get());
        boolean hasResistance = cap.resistance > 0;
        cap.isSource = !hasResistance;
        cap.isNeighbor = true;
        ++cap.count;
        if (hasResistance) {
            CorruptionCapability.sendFlowerParticles(chunk);
        }
    }

    public static void cure(LevelChunk chunk) {
        CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION.get());
        cap.count = 0;
        cap.isSource = false;
        cap.isNeighbor = false;
    }

    public static boolean areDifferentChunks(Level level, BlockPos pos1, BlockPos pos2) {
        return !level.getChunkAt(pos1).getPos().equals((Object)level.getChunkAt(pos2).getPos());
    }

    public static CorruptionCapability get(LevelChunk chunk) {
        return (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION.get());
    }

    public static void printDebug(LevelChunk chunk) {
        if (chunk.getLevel().isClientSide()) {
            return;
        }
        CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION.get());
        System.out.println("Count: " + cap.count + " Resistance: " + cap.resistance + " isSource: " + cap.isSource + " isNeighbor: " + cap.isNeighbor + " Flowers size: " + cap.flowers.size());
    }
}

