/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.toClient.SyncGluedPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class GluedCapability {
    public static final Codec<GluedCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("is_glued").forGetter(data -> data.isGlued)).apply((Applicative)instance, glued -> {
        GluedCapability data = new GluedCapability();
        data.isGlued = glued;
        return data;
    }));
    public boolean isGlued;

    public static void setAndSync(LivingEntity entity, boolean isGlued, boolean playSound) {
        Level level = entity.level();
        if (playSound) {
            GluedCapability.playSound(level, (Entity)entity);
        }
        GluedCapability cap = (GluedCapability)entity.getData(ModDataAttachments.GLUED.get());
        cap.isGlued = isGlued;
        cap.sync(entity);
    }

    public void sync(LivingEntity entity) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncGluedPacket(this.isGlued, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void playSound(Level level, Entity entity) {
        level.playSound(null, entity.getOnPos(), SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.PLAYERS, 5.0f, 0.02f + level.random.nextFloat() * 0.01f);
    }
}

