/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.slot;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.HardenedMouthCapability;
import net.abraxator.moresnifferflowers.client.gui.slot.DummyContainer;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class HardenedMouthSlot
extends Slot {
    private final Player player;
    private final int index;
    private final Supplier<HardenedMouthCapability> itemStorage;

    public HardenedMouthSlot(Player player, int index, int x, int y, Supplier<HardenedMouthCapability> itemStorage) {
        super((Container)DummyContainer.INSTANCE, index, x, y);
        this.player = player;
        this.index = index;
        this.itemStorage = itemStorage;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.hasHardenedMouthEffect();
    }

    public boolean isActive() {
        return this.hasHardenedMouthEffect();
    }

    public boolean mayPickup(Player playerIn) {
        return this.hasHardenedMouthEffect();
    }

    public boolean isHighlightable() {
        return this.hasHardenedMouthEffect();
    }

    public ItemStack getItem() {
        return this.itemStorage.get().getItem(this.index);
    }

    public void set(ItemStack stack) {
        if (this.itemStorage.get() == null) {
            System.out.println("fuck");
            return;
        }
        this.itemStorage.get().setItem(this.index, stack);
    }

    public void setChanged() {
        ((HardenedMouthCapability)this.player.getData(ModDataAttachments.HARDENED_MOUTH)).sync(this.player);
    }

    public void handleCapabilitySlotClick(HardenedMouthSlot slot, Player player, ClickType clickType, int dragType) {
        boolean isRightClick;
        ItemStack slotStack = slot.getItem();
        InventoryMenu menu = player.inventoryMenu;
        ItemStack carried = menu.getCarried();
        boolean bl = isRightClick = dragType == 1;
        if (player.level().isClientSide) {
            return;
        }
        switch (clickType) {
            case PICKUP: 
            case QUICK_CRAFT: 
            case PICKUP_ALL: {
                if (slotStack.isEmpty()) {
                    if (carried.isEmpty()) break;
                    int toPlace = isRightClick ? 1 : carried.getCount();
                    slot.set(carried.split(toPlace));
                    break;
                }
                if (carried.isEmpty()) {
                    int toTake = isRightClick ? (int)Math.ceil((double)slotStack.getCount() / 2.0) : slotStack.getCount();
                    ItemStack taken = slotStack.split(toTake);
                    menu.setCarried(taken);
                    break;
                }
                if (HardenedMouthSlot.canStack(carried, slotStack)) {
                    int maxTransfer = Math.min(carried.getCount(), slotStack.getMaxStackSize() - slotStack.getCount());
                    slotStack.grow(maxTransfer);
                    carried.shrink(maxTransfer);
                    slot.set(slotStack);
                    break;
                }
                slot.set(carried);
                menu.setCarried(slotStack);
                break;
            }
            case QUICK_MOVE: {
                if (slotStack.isEmpty()) break;
                if (!HardenedMouthSlot.moveToPlayerInventory((AbstractContainerMenu)menu, slotStack)) {
                    return;
                }
                slot.set(ItemStack.EMPTY);
                break;
            }
        }
        slot.setChanged();
    }

    public static boolean canStack(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static boolean moveToPlayerInventory(AbstractContainerMenu menu, ItemStack stackToMove) {
        for (int i = 8; i < 36; ++i) {
            int transferable;
            Slot target = menu.getSlot(i);
            if (!target.mayPlace(stackToMove)) continue;
            ItemStack targetStack = target.getItem();
            if (targetStack.isEmpty()) {
                target.set(stackToMove.copy());
                stackToMove.setCount(0);
                return true;
            }
            if (!HardenedMouthSlot.canStack(stackToMove, targetStack) || (transferable = Math.min(stackToMove.getCount(), targetStack.getMaxStackSize() - targetStack.getCount())) <= 0) continue;
            targetStack.grow(transferable);
            stackToMove.shrink(transferable);
            target.set(targetStack);
            if (!stackToMove.isEmpty()) continue;
            return true;
        }
        return stackToMove.isEmpty();
    }

    public boolean hasHardenedMouthEffect() {
        return this.player.hasEffect(ModEffects.HARDENED_MOUTH);
    }
}

