/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class DragonflyModel
extends Model {
    private final ModelPart root;
    private final ModelPart wing1;
    private final ModelPart wing2;

    public DragonflyModel(ModelPart root) {
        super(RenderType::entityCutout);
        this.root = root.getChild("root");
        this.wing1 = this.root.getChild("wing1");
        this.wing2 = this.root.getChild("wing2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -8.0f, -6.0f, 3.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r1 = root.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 0.0f, -1.5f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0303f, (float)-7.1768f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-2.3562f));
        PartDefinition cube_r2 = root.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, 0.25f, -1.5f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-7.0f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r3 = root.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -1.0f, -1.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)4.4f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition wing1_r1 = root.addOrReplaceChild("wing1", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(-4.5f, -8.5f, 0.0f, 9.0f, 17.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.0544f, (float)-6.9982f, (float)-0.5f, (float)1.7975f, (float)-1.5708f, (float)-2.8975f));
        PartDefinition wing2_r1 = root.addOrReplaceChild("wing2", CubeListBuilder.create().texOffs(0, 11).addBox(-5.0f, -8.0f, 0.0f, 9.0f, 17.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-7.225f, (float)-1.0f, (float)1.7975f, (float)1.5708f, (float)2.8975f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void animate(float pPartialTick) {
        this.wing1.zRot = (float)((double)(Mth.cos((float)(pPartialTick * 100.0f * (float)Math.PI / 180.0f)) * (float)Math.PI) * 0.25);
        this.wing2.zRot = (float)(-((double)(Mth.cos((float)(pPartialTick * 100.0f * (float)Math.PI / 180.0f)) * (float)Math.PI) * 0.25));
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }
}

