/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.config.ModClientConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.lighting.QuadLighter;
import org.joml.Matrix4f;

public class BlockPatternRenderer {
    public static final CameraTracker CAMERA_TRACKER = new CameraTracker();
    public static final BlockPatternRenderer BUFFER_MANAGER = new BlockPatternRenderer();
    private boolean dirty = true;
    private final List<RenderQuad> cachedQuads = new ArrayList<RenderQuad>();

    public static void cacheAndRender(Frustum frustum, Camera camera, Level level, Minecraft minecraft, PoseStack poseStack) {
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        if (level == null || minecraft.player == null) {
            return;
        }
        if (CAMERA_TRACKER.hasMoved(camera)) {
            BUFFER_MANAGER.markDirty();
        }
        int chunkRenderDistance = Math.min(ModClientConfig.getBlockPatternRenderDistance(), minecraft.options.getEffectiveRenderDistance());
        poseStack.pushPose();
        poseStack.translate(-camX, -camY, -camZ);
        ArrayList<LevelChunk> levelChunks = new ArrayList<LevelChunk>();
        ChunkPos playerChunkPos = minecraft.player.chunkPosition();
        for (int x = -chunkRenderDistance; x < chunkRenderDistance; ++x) {
            for (int z = -chunkRenderDistance; z < chunkRenderDistance; ++z) {
                levelChunks.add(level.getChunk(x + playerChunkPos.x, z + playerChunkPos.z));
            }
        }
        BUFFER_MANAGER.cachePatterns(level, camX, camY, camZ, levelChunks, frustum);
        BUFFER_MANAGER.render(poseStack, Minecraft.getInstance().renderBuffers().bufferSource());
        poseStack.popPose();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void cachePatterns(Level level, double camX, double camY, double camZ, List<LevelChunk> levelChunks, Frustum frustum) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.cachedQuads.clear();
        frustum.prepare(camX, camY, camZ);
        for (LevelChunk chunk : levelChunks) {
            BlockPatternCapability storage = (BlockPatternCapability)chunk.getData(ModDataAttachments.BLOCK_PATTERNS);
            Stream patternPositions = storage.getPatterns().keySet().stream();
            patternPositions.forEach(pos -> {
                BlockPatternCapability.PatternData data = storage.getPattern((BlockPos)pos);
                if (data == null || !frustum.isVisible(new AABB(pos))) {
                    return;
                }
                ResourceLocation resourceLocation = MoreSnifferFlowers.loc("block/block_pattern/" + BlockPattern.fromId(data.patternId()).getSerializedName());
                TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(resourceLocation);
                BlockState state = level.getBlockState(pos);
                for (Direction dir : Direction.values()) {
                    int[] lightmap;
                    boolean canRenderFace;
                    BlockPos relativePos = pos.relative(dir);
                    BlockState relativeState = level.getBlockState(relativePos);
                    boolean faceSturdy = state.isFaceSturdy((BlockGetter)level, pos, dir);
                    boolean notBlocked = !relativeState.isFaceSturdy((BlockGetter)level, relativePos, dir.getOpposite());
                    boolean noOcclusion = !relativeState.canOcclude();
                    boolean bl = canRenderFace = faceSturdy && (notBlocked || noOcclusion);
                    if (!canRenderFace) continue;
                    float[] brightness = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                    boolean smoothLighting = (Boolean)ModClientConfig.BLOCK_PATTERN_SMOOTH_LIGHTING.get();
                    if (smoothLighting) {
                        ModelBlockRenderer.AmbientOcclusionFace aoFace = new ModelBlockRenderer.AmbientOcclusionFace();
                        aoFace.calculate((BlockAndTintGetter)level, state, relativePos, dir, new float[Direction.values().length * 2], new BitSet(3), true);
                        brightness = aoFace.brightness;
                        lightmap = aoFace.lightmap;
                    } else {
                        int packed = BlockPatternRenderer.getPackedLight(level, relativePos);
                        if (data.isGlowing()) {
                            packed = 0xF000F0;
                        }
                        lightmap = new int[]{packed, packed, packed, packed};
                    }
                    this.cachedQuads.add(RenderQuad.create(pos, dir, data.color(), sprite, smoothLighting, data.direction(), data.isGlowing(), brightness, lightmap));
                }
            });
        }
    }

    public void render(PoseStack stack, MultiBufferSource.BufferSource bufferSource) {
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutoutMipped());
        if (ModClientConfig.CLIENT_CONFIG.isLoaded() && ((Boolean)ModClientConfig.BLOCK_PATTERN_TRANSPARENCY.get()).booleanValue()) {
            buffer = bufferSource.getBuffer(RenderType.translucent());
        }
        for (RenderQuad quad : this.cachedQuads) {
            quad.render(stack, buffer);
        }
        bufferSource.endLastBatch();
    }

    private static void translateToFace(PoseStack stack, Direction face, BlockPos pos) {
        double configOffset = 0.001f;
        float distance = (float)(configOffset * (double)(Math.abs((pos.getX() + pos.getY() + pos.getZ()) % 4) + 1));
        float scale = distance * 2.0f;
        switch (face) {
            case UP: {
                stack.translate(1.0f, 1.0f + distance, 0.0f);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.mulPose(Axis.XP.rotationDegrees(180.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
                break;
            }
            case DOWN: {
                stack.translate(1.0f, 0.0f - distance, 1.0f);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
                break;
            }
            case NORTH: {
                stack.translate(0.0f, 1.0f, 0.0f - distance);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
                break;
            }
            case SOUTH: {
                stack.translate(1.0f, 1.0f, 1.0f + distance);
                stack.mulPose(Axis.XN.rotationDegrees(90.0f));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
                break;
            }
            case WEST: {
                stack.translate(0.0f - distance, 1.0f, 1.0f);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
                break;
            }
            case EAST: {
                stack.translate(1.0f + distance, 1.0f, 0.0f);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                stack.scale(1.0f + scale, 1.0f, 1.0f + scale);
                stack.translate(-distance, 0.0f, -distance);
            }
        }
    }

    public static int getPackedLight(Level level, BlockPos pos) {
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }

    public static class CameraTracker {
        private Vec3 lastPosition = Vec3.ZERO;
        private float lastYaw = 0.0f;
        private float lastPitch = 0.0f;
        private static final double MOVE_THRESHOLD = (double)0.01f;
        private static final float ROTATE_THRESHOLD = 0.2f;

        public boolean hasMoved(Camera camera) {
            Vec3 currentPos = camera.getPosition();
            float yaw = camera.getYRot();
            float pitch = camera.getXRot();
            double dx = currentPos.x - this.lastPosition.x;
            double dy = currentPos.y - this.lastPosition.y;
            double dz = currentPos.z - this.lastPosition.z;
            double distSq = dx * dx + dy * dy + dz * dz;
            float deltaYaw = Math.abs(yaw - this.lastYaw);
            float deltaPitch = Math.abs(pitch - this.lastPitch);
            this.update(camera);
            return distSq > 9.999999552965169E-5 || deltaYaw > 0.2f || deltaPitch > 0.2f;
        }

        public void update(Camera camera) {
            this.lastPosition = camera.getPosition();
            this.lastYaw = camera.getYRot();
            this.lastPitch = camera.getXRot();
        }
    }

    public record RenderQuad(BlockPos pos, Direction direction, int color, TextureAtlasSprite sprite, boolean smoothLighting, Direction rotation, boolean isGlowing, float[] brightness, int[] lightmap) {
        public static RenderQuad create(BlockPos pos, Direction face, int color, TextureAtlasSprite sprite, boolean smoothLighting, Direction rotation, boolean isGlowing, float[] brightness, int[] lightmap) {
            return new RenderQuad(pos.immutable(), face, color, sprite, smoothLighting, rotation, isGlowing, brightness, lightmap);
        }

        private void render(PoseStack poseStack, VertexConsumer buffer) {
            poseStack.pushPose();
            poseStack.translate((float)this.pos.getX(), (float)this.pos.getY(), (float)this.pos.getZ());
            BlockPatternRenderer.translateToFace(poseStack, this.direction, this.pos);
            Vec3i n = this.direction.getNormal();
            float nx = n.getX();
            float ny = n.getY();
            float nz = n.getZ();
            int rgb = this.color;
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            if (!this.smoothLighting) {
                float ao = QuadLighter.calculateShade((float)nx, (float)ny, (float)nz, (boolean)false);
                if (!this.isGlowing) {
                    r *= ao;
                    g *= ao;
                    b *= ao;
                }
            }
            Matrix4f pose = poseStack.last().pose();
            float u0 = this.sprite.getU1();
            float u1 = this.sprite.getU0();
            float u2 = this.sprite.getU0();
            float u3 = this.sprite.getU1();
            float v0 = this.sprite.getV1();
            float v1 = this.sprite.getV1();
            float v2 = this.sprite.getV0();
            float v3 = this.sprite.getV0();
            if (this.rotation == Direction.EAST) {
                u0 = this.sprite.getU0();
                u1 = this.sprite.getU0();
                u2 = this.sprite.getU1();
                u3 = this.sprite.getU1();
                v0 = this.sprite.getV0();
                v1 = this.sprite.getV1();
                v2 = this.sprite.getV1();
                v3 = this.sprite.getV0();
            }
            if (this.rotation == Direction.SOUTH) {
                u0 = this.sprite.getU0();
                u1 = this.sprite.getU1();
                u2 = this.sprite.getU1();
                u3 = this.sprite.getU0();
                v0 = this.sprite.getV0();
                v1 = this.sprite.getV0();
                v2 = this.sprite.getV1();
                v3 = this.sprite.getV1();
            }
            if (this.rotation == Direction.WEST) {
                u0 = this.sprite.getU1();
                u1 = this.sprite.getU1();
                u2 = this.sprite.getU0();
                u3 = this.sprite.getU0();
                v0 = this.sprite.getV1();
                v1 = this.sprite.getV0();
                v2 = this.sprite.getV0();
                v3 = this.sprite.getV1();
            }
            float brightness0 = this.brightness[0];
            float brightness1 = this.brightness[1];
            float brightness2 = this.brightness[2];
            float brightness3 = this.brightness[3];
            if (this.isGlowing) {
                brightness0 = 1.0f;
                brightness1 = 1.0f;
                brightness2 = 1.0f;
                brightness3 = 1.0f;
                this.lightmap[0] = 0xF000F0;
                this.lightmap[1] = 0xF000F0;
                this.lightmap[2] = 0xF000F0;
                this.lightmap[3] = 0xF000F0;
            }
            buffer.addVertex(pose, 1.0f, 0.0f, 0.0f).setColor(r * brightness0, g * brightness0, b * brightness0, 1.0f).setUv(u1, v2).setLight(this.lightmap[0]).setNormal(poseStack.last(), nx, ny, nz);
            buffer.addVertex(pose, 1.0f, 0.0f, 1.0f).setColor(r * brightness1, g * brightness1, b * brightness1, 1.0f).setUv(u2, v1).setLight(this.lightmap[1]).setNormal(poseStack.last(), nx, ny, nz);
            buffer.addVertex(pose, 0.0f, 0.0f, 1.0f).setColor(r * brightness2, g * brightness2, b * brightness2, 1.0f).setUv(u3, v0).setLight(this.lightmap[2]).setNormal(poseStack.last(), nx, ny, nz);
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r * brightness3, g * brightness3, b * brightness3, 1.0f).setUv(u0, v3).setLight(this.lightmap[3]).setNormal(poseStack.last(), nx, ny, nz);
            poseStack.popPose();
        }
    }
}

