/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.client.model.entity.CorruptedProjectileModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class CoolProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final CorruptedProjectileModel model;

    protected CoolProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CorruptedProjectileModel(context.bakeLayer(ModModelLayerLocations.CORRUPTED_PROJECTILE));
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (CoolProjectileRenderer.projectileCameraCheck(entity, this.entityRenderDispatcher)) {
            CoolProjectileRenderer.projectileRendering(entity, partialTick, poseStack, buffer, packedLight, this.model, this.getTextureLocation((Entity)entity));
            super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        }
    }

    public static void projectileRendering(Entity pEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, Model model, ResourceLocation location) {
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.yRotO, (float)pEntity.getYRot()) - 180.0f));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.xRotO, (float)pEntity.getXRot())));
        pPoseStack.translate(0.0, -0.5, 0.0);
        float scale = 0.6f;
        pPoseStack.scale(scale, scale, scale);
        model.renderToBuffer(pPoseStack, pBufferSource.getBuffer(model.renderType(location)), pPackedLight, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
    }

    public static boolean projectileCameraCheck(Entity entity, EntityRenderDispatcher renderer) {
        return entity.tickCount >= 2 || !(renderer.camera.getEntity().distanceToSqr(entity) < 12.25);
    }
}

