/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.client.model.entity.DragonflyModel;
import net.abraxator.moresnifferflowers.entities.DragonflyProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class DragonflyRenderer
extends EntityRenderer<DragonflyProjectile> {
    public static final ResourceLocation TEXTURE = MoreSnifferFlowers.loc("textures/entity/dragonfly.png");
    private final DragonflyModel model;

    public DragonflyRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new DragonflyModel(context.bakeLayer(ModModelLayerLocations.DRAGONFLY));
    }

    public void render(DragonflyProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.yRotO, (float)pEntity.getYRot()) - 180.0f));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.xRotO, (float)pEntity.getXRot())));
        pPoseStack.translate(0.0, -1.0, 0.5);
        this.model.renderToBuffer(pPoseStack, pBufferSource.getBuffer(this.model.renderType(this.getTextureLocation(pEntity))), pPackedLight, OverlayTexture.NO_OVERLAY);
        this.model.animate(pPartialTick);
        pPoseStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
    }

    public ResourceLocation getTextureLocation(DragonflyProjectile dragonflyProjectile) {
        return TEXTURE;
    }
}

