/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import java.util.Arrays;
import java.util.Objects;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.PatternspriaItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public enum BlockPattern implements StringRepresentable
{
    PIPES("pipes", MoreSnifferFlowers.loc("block_pattern_pipes"), 0, -8802219, DyeColor.LIME),
    BRICKS("bricks", MoreSnifferFlowers.loc("block_pattern_bricks"), 1, -5356164, DyeColor.MAGENTA),
    FOCUS("focus", MoreSnifferFlowers.loc("block_pattern_focus"), 2, -9814649, DyeColor.PURPLE),
    BUBBLES("bubbles", MoreSnifferFlowers.loc("block_pattern_bubbles"), 3, -9585222, DyeColor.LIGHT_BLUE),
    CLOUDS("clouds", MoreSnifferFlowers.loc("block_pattern_clouds"), 4, -2236976, DyeColor.WHITE),
    DEEPSLATE("deepslate", MoreSnifferFlowers.loc("block_pattern_deepslate"), 5, -12501167, DyeColor.BLACK),
    DIAMOND("diamond", MoreSnifferFlowers.loc("block_pattern_diamond"), 6, -11888505, DyeColor.CYAN),
    EYE("eye", MoreSnifferFlowers.loc("block_pattern_eye"), 7, -6773337, DyeColor.LIGHT_GRAY),
    HEARTS("hearts", MoreSnifferFlowers.loc("block_pattern_hearts"), 8, -5882309, DyeColor.RED),
    HONEYCOMB("honeycomb", MoreSnifferFlowers.loc("block_pattern_honeycomb"), 9, -4293830, DyeColor.ORANGE),
    PAWS("paws", MoreSnifferFlowers.loc("block_pattern_paws"), 10, -8562624, DyeColor.BROWN),
    PRISMARINE("prismarine", MoreSnifferFlowers.loc("block_pattern_prismarine"), 11, -11316819, DyeColor.BLUE),
    SPROUTS("sprouts", MoreSnifferFlowers.loc("block_pattern_sprouts"), 12, -11631034, DyeColor.GREEN),
    STARS("stars", MoreSnifferFlowers.loc("block_pattern_stars"), 13, -1125278, DyeColor.YELLOW),
    COVER("cover", MoreSnifferFlowers.loc("block_pattern_cover"), 14, -9213575, DyeColor.GRAY),
    FLOWERS("flowers", MoreSnifferFlowers.loc("block_pattern_flowers"), 15, -4956762, DyeColor.PINK),
    FLOWER_CHARGE("flower_charge", MoreSnifferFlowers.vanillaLoc("flower_banner_pattern"), 16, -5194, null),
    GLOBE("globe", MoreSnifferFlowers.vanillaLoc("globe_banner_pattern"), 17, -5194, null),
    SNOUT("snout", MoreSnifferFlowers.vanillaLoc("piglin_banner_pattern"), 18, -5194, null),
    CREEPER_CHARGE("creeper_charge", MoreSnifferFlowers.vanillaLoc("creeper_banner_pattern"), 19, -5194, null),
    SKULL_CHARGE("skull_charge", MoreSnifferFlowers.vanillaLoc("skull_banner_pattern"), 20, -5194, null),
    THING("thing", MoreSnifferFlowers.vanillaLoc("mojang_banner_pattern"), 21, -5194, null),
    AMBUSH("ambush", MoreSnifferFlowers.loc("ambush_banner_pattern"), 22, -5194, null),
    EVIL("evil", MoreSnifferFlowers.loc("evil_banner_pattern"), 23, -5194, null),
    EMPTY("empty", null, -1, -2236976, null);

    private final String name;
    private final ResourceLocation item;
    private final int id;
    private final int color;
    private final DyeColor dyeColor;

    private BlockPattern(String name, ResourceLocation item, int id, int color, DyeColor dyeColor) {
        this.name = name;
        this.item = item;
        this.id = id;
        this.color = color;
        this.dyeColor = dyeColor;
    }

    public static BlockPattern fromId(int index) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> blockPattern.id == index).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromItem(Item item) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> Objects.equals(blockPattern.item, BuiltInRegistries.ITEM.getKey((Object)item))).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromDyeColor(DyeColor dyeColor) {
        return Arrays.stream(BlockPattern.values()).filter(blockPattern -> blockPattern.dyeColor == dyeColor).findFirst().orElse(EMPTY);
    }

    public static BlockPattern fromState(BlockState state) {
        return (BlockPattern)((Object)state.getValue(ModStateProperties.BLOCK_PATTERN));
    }

    public static BlockPattern fromPatternspria(ItemStack stack) {
        if (stack.has(ModDataComponents.PATTERN_ID)) {
            int patternId = (Integer)stack.getOrDefault(ModDataComponents.PATTERN_ID, (Object)0);
            return BlockPattern.fromId(patternId);
        }
        return EMPTY;
    }

    public int getColor() {
        return this.color;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Item getItem() {
        return (Item)BuiltInRegistries.ITEM.get(this.item);
    }

    public boolean isBanner() {
        return this.id > 15 && this.id < 24;
    }

    public boolean isSamePattern(ItemStack patternspria) {
        int patternId = (Integer)patternspria.getOrDefault(ModDataComponents.PATTERN_ID, (Object)0);
        return patternId == this.id;
    }

    public ItemStack getItemStack(ItemStack patternspria) {
        int amount = (Integer)patternspria.getOrDefault(ModDataComponents.AMOUNT, (Object)1);
        return this.getItem().getDefaultInstance().copyWithCount(amount);
    }

    public static ItemStack getItemStackFromPatternspria(ItemStack patternspria) {
        return BlockPattern.fromPatternspria(patternspria).getItemStack(patternspria);
    }

    public static void setPatternToHolderStack(ItemStack itemStack, ItemStack patternToInsert, int amount) {
        BlockPattern.setPatternToHolderStack(itemStack, patternToInsert, amount, PatternspriaItem.getPatternspriaUses(itemStack));
    }

    public static void setPatternToHolderStack(ItemStack itemStack, ItemStack patternToInsert, int amount, int uses) {
        if (BlockPattern.fromItem(patternToInsert.getItem()) == EMPTY) {
            BlockPattern.removePatternFromStack(itemStack);
            return;
        }
        int patternId = Objects.requireNonNull(BlockPattern.fromItem(patternToInsert.getItem())).getId();
        itemStack.set(ModDataComponents.AMOUNT, (Object)amount);
        itemStack.set(ModDataComponents.PATTERN_ID, (Object)patternId);
        itemStack.set(ModDataComponents.USES, (Object)uses);
    }

    public static void removePatternFromStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.AMOUNT, (Object)0);
        itemStack.set(ModDataComponents.PATTERN_ID, (Object)-1);
        itemStack.set(ModDataComponents.USES, (Object)0);
    }

    public static boolean isEmpty(BlockState state) {
        return state.getValue(ModStateProperties.BLOCK_PATTERN) == EMPTY;
    }
}

