/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SaltProjectile
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> CORRUPTED = SynchedEntityData.defineId(SaltProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SaltProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SaltProjectile(Level level, LivingEntity pShooter) {
        super((EntityType)ModEntityTypes.SALT_PROJECTILE.get(), pShooter, level);
    }

    public SaltProjectile(Level level) {
        super((EntityType)ModEntityTypes.SALT_PROJECTILE.get(), level);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockPos posRelative = result.getBlockPos().relative(result.getDirection());
        BlockState state = this.level().getBlockState(pos);
        BlockState stateRelative = this.level().getBlockState(posRelative);
        if (this.level().isClientSide) {
            return;
        }
        if (!this.isCorrupted()) {
            if (this.placeBlockSalt(pos, state)) {
                this.discard();
            } else if (this.placeBlockSalt(posRelative, stateRelative)) {
                this.discard();
            }
        } else if (this.placeBlockSour(pos, 0)) {
            this.discard();
        } else if (this.placeBlockSour(posRelative, 0)) {
            this.discard();
        }
    }

    public boolean placeBlockSalt(BlockPos pos, BlockState state) {
        Level level = this.level();
        if (state.canBeReplaced()) {
            if (!((Block)ModBlocks.SALTY_CLUMP.get()).defaultBlockState().canSurvive((LevelReader)level, pos)) {
                return true;
            }
            level.setBlock(pos, (BlockState)((Block)ModBlocks.SALTY_CLUMP.get()).defaultBlockState().setValue((Property)ModStateProperties.AMOUNT_4, (Comparable)Integer.valueOf(1)), 2);
            return true;
        }
        if (state.is((Block)ModBlocks.SALTY_CLUMP.get())) {
            int amount = (Integer)state.getValue((Property)ModStateProperties.AMOUNT_4);
            if (amount < 4) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ModStateProperties.AMOUNT_4, (Comparable)Integer.valueOf(amount + 1)), 3);
            } else {
                level.setBlock(pos, (BlockState)((Block)ModBlocks.DRIPSALT.get()).defaultBlockState().setValue((Property)BlockStateProperties.VERTICAL_DIRECTION, (Comparable)Direction.UP), 3);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockSour(BlockPos pos, int loop) {
        Level level = this.level();
        BlockState newState = level.getBlockState(pos);
        if (loop > 2) {
            return false;
        }
        if (newState.canBeReplaced()) {
            if (!((Block)ModBlocks.SOUR_PUDDLE.get()).defaultBlockState().canSurvive((LevelReader)level, pos)) {
                return true;
            }
            level.setBlock(pos, ((Block)ModBlocks.SOUR_PUDDLE.get()).defaultBlockState(), 3);
            return true;
        }
        if (newState.is((Block)ModBlocks.SOUR_PUDDLE.get())) {
            return this.placeBlockSour(SaltProjectile.aroundPos(pos, this.random.nextInt(7)), loop + 1);
        }
        return false;
    }

    public static BlockPos aroundPos(BlockPos pos, int direction) {
        return switch (direction) {
            case 0 -> pos.north().west();
            case 1 -> pos.north();
            case 2 -> pos.north().east();
            case 3 -> pos.east();
            case 4 -> pos.south().east();
            case 5 -> pos.south();
            case 6 -> pos.south().west();
            case 7 -> pos.west();
            default -> pos;
        };
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.SALTY_SPICE.get();
    }

    public boolean isCorrupted() {
        return (Boolean)this.entityData.get(CORRUPTED);
    }

    public void setCorrupted(boolean corrupted) {
        this.entityData.set(CORRUPTED, (Object)corrupted);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("corrupted", this.isCorrupted());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCorrupted(tag.getBoolean("corrupted"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CORRUPTED, (Object)false);
    }
}

