/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.GluedCapability;
import net.abraxator.moresnifferflowers.capability.SlipperyCapability;
import net.abraxator.moresnifferflowers.client.renderer.custom.BlockPatternRenderer;
import net.abraxator.moresnifferflowers.client.renderer.custom.GhostRenderer;
import net.abraxator.moresnifferflowers.entities.GluingGumEntity;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.networking.toServer.DyespriaModePacket;
import net.abraxator.moresnifferflowers.networking.toServer.PatternspriaModePacket;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="moresnifferflowers", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onInputMouseScrolling(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.isCrouching() && player.getMainHandItem().is((Item)ModItems.DYESPRIA.get())) {
            event.setCanceled(true);
            PacketDistributor.sendToServer((CustomPacketPayload)new DyespriaModePacket((int)event.getScrollDeltaY()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (player.isCrouching() && player.getMainHandItem().is((Item)ModItems.PATTERNSPRIA.get())) {
            event.setCanceled(true);
            PacketDistributor.sendToServer((CustomPacketPayload)new PatternspriaModePacket((int)event.getScrollDeltaY()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void renderLevelStage(RenderLevelStageEvent event) {
        RenderLevelStageEvent.Stage stage = event.getStage();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Frustum frustum = event.getFrustum();
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            BlockPatternRenderer.cacheAndRender(frustum, camera, (Level)level, minecraft, poseStack);
            GhostRenderer.renderAll(partialTicks, frustum, camera, (Level)level, poseStack);
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        GhostRenderer.tickAll();
    }

    @SubscribeEvent
    public static void renderLiving(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        GluedCapability cap = (GluedCapability)entity.getData(ModDataAttachments.GLUED);
        if (cap.isGlued) {
            Player player;
            Vec3 pos = entity.position();
            Minecraft minecraft = Minecraft.getInstance();
            PoseStack poseStack = event.getPoseStack();
            GluingGumEntity gum = new GluingGumEntity(entity.level());
            gum.setPos(pos.x, pos.y, pos.z);
            poseStack.pushPose();
            float yOff = 0.0f;
            if (entity instanceof Player && (player = (Player)entity).isCrouching()) {
                yOff += 0.13f;
            }
            minecraft.getEntityRenderDispatcher().render((Entity)gum, 0.0, (double)yOff, 0.0, entity.yBodyRot, event.getPartialTick(), poseStack, event.getMultiBufferSource(), event.getPackedLight());
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void renderGuiOverlay(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.hasEffect(ModEffects.GLUED)) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.getInstance();
        int width = mc.getWindow().getGuiScaledWidth();
        int height = mc.getWindow().getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation texture = MoreSnifferFlowers.loc("textures/gui/glued_overlay.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.blit(texture, 0, 0, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
    }

    @SubscribeEvent
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        PoseStack pose = event.getPoseStack();
        if (player.hasEffect(ModEffects.SLIPPERY)) {
            SlipperyCapability cap = (SlipperyCapability)player.getData(ModDataAttachments.SLIPPERY);
            if (cap.isFallen) {
                pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
                pose.translate(0.0, -0.5, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.getDeltaMovement() == Vec3.ZERO || player.level().getGameTime() % 10L == 0L) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPatternRenderer.BUFFER_MANAGER.markDirty();
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockPatternRenderer.BUFFER_MANAGER.markDirty();
    }
}

