/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.events;

import java.util.Objects;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.capability.ComboMealCapability;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.capability.GluedCapability;
import net.abraxator.moresnifferflowers.capability.HardenedMouthCapability;
import net.abraxator.moresnifferflowers.capability.SlipperyCapability;
import net.abraxator.moresnifferflowers.capability.UntouchableCapability;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.items.JarOfBonmeelItem;
import net.abraxator.moresnifferflowers.nutrition.NutritionLoader;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;

@EventBusSubscriber(modid="moresnifferflowers")
public class ForgeEvents {
    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new NutritionLoader());
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Sent event) {
        ServerLevel level = event.getLevel();
        LevelChunk chunk = event.getChunk();
        ((BlockPatternCapability)chunk.getData(ModDataAttachments.BLOCK_PATTERNS)).sync(chunk.getPos().getMiddleBlockPosition(0), (Level)level);
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        Holder effect = event.getEffectInstance().getEffect();
        LivingEntity entity = event.getEntity();
        if (effect.equals(ModEffects.GLUED)) {
            GluedCapability.setAndSync(entity, true, true);
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (effect == null) {
            return;
        }
        ForgeEvents.onEffectEnd((Holder<MobEffect>)effect.getEffect(), entity);
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (effect == null) {
            return;
        }
        ForgeEvents.onEffectEnd((Holder<MobEffect>)effect.getEffect(), entity);
    }

    public static void onEffectEnd(Holder<MobEffect> effect, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.equals(ModEffects.HARDENED_MOUTH)) {
                ((HardenedMouthCapability)player.getData(ModDataAttachments.HARDENED_MOUTH)).onEffectEnd(player);
            }
            if (effect.equals(ModEffects.SLIPPERY)) {
                ((SlipperyCapability)player.getData(ModDataAttachments.SLIPPERY)).onEffectEnd(player);
            }
            if (effect.equals(ModEffects.COMBO_MEAL)) {
                ((ComboMealCapability)player.getData(ModDataAttachments.COMBO_MEAL)).onEffectEnd(player);
            }
            if (effect.equals(ModEffects.UNTOUCHABLE)) {
                ((UntouchableCapability)player.getData(ModDataAttachments.UNTOUCHABLE)).onEffectEnd(player);
            }
        }
        if (effect.equals(ModEffects.GLUED)) {
            GluedCapability.setAndSync(entity, false, true);
        }
    }

    @SubscribeEvent
    public static void itemEntity(ItemTossEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack item = itemEntity.getItem();
        if (item.is(ModItems.BURNED_SLOT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        boolean isCharged = player.getAttackStrengthScale(0.5f) > 0.9f;
        Entity entity = event.getTarget();
        Level level = player.level();
        if (player.hasEffect(ModEffects.COMBO_MEAL) && stack.is(Tags.Items.MELEE_WEAPON_TOOLS)) {
            ((ComboMealCapability)player.getData(ModDataAttachments.COMBO_MEAL)).onAttack(player, isCharged);
        }
        if (player.hasEffect(ModEffects.GLUING_TOUCH) && isCharged && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!level.isClientSide) {
                int amplifier = Objects.requireNonNull(player.getEffect(ModEffects.GLUING_TOUCH)).getAmplifier();
                if (level.random.nextFloat() < (float)(amplifier + 2) / 12.0f) {
                    livingEntity.addEffect(new MobEffectInstance(ModEffects.GLUED, (5 + amplifier * 2) * 20, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemEntity itemEntity = event.getItemEntity();
        if (player.hasEffect(ModEffects.STICKY)) {
            if (!player.isCrouching()) {
                event.setCanPickup(TriState.FALSE);
            } else {
                int amplifier = player.getEffect(ModEffects.STICKY).getAmplifier();
                int slowdown = 5 + amplifier * 2;
                if (player.level().getGameTime() % (long)slowdown != 0L) {
                    event.setCanPickup(TriState.FALSE);
                    return;
                }
                ItemStack stack = itemEntity.getItem();
                ItemStack retStack = stack.split(1);
                player.addItem(retStack);
                itemEntity.setItem(stack);
                event.setCanPickup(TriState.FALSE);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3 loc;
        BlockPos blockPos;
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.level();
        if (level.getBlockState(blockPos = BlockPos.containing((Position)(loc = livingEntity.position()))).is(ModBlocks.CORRUPTED_SLIME_LAYER) || level.getBlockState(blockPos.below()).is(ModBlocks.CORRUPTED_SLIME_LAYER)) {
            livingEntity.setDeltaMovement(livingEntity.getDeltaMovement().multiply(1.0, 0.3, 1.0));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        LevelAccessor badLevel = event.getLevel();
        if (state.is(ModTags.ModBlockTags.CORRUPTION_SHIELDING) && badLevel instanceof Level) {
            Level level = (Level)badLevel;
            LevelChunk chunk = level.getChunkAt(event.getPos());
            CorruptionCapability cap = (CorruptionCapability)chunk.getData(ModDataAttachments.CHUNK_CORRUPTION);
            ++cap.resistance;
            cap.isSource = false;
            cap.flowers.add(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack output = event.getCrafting();
        Container input = event.getInventory();
        if (output.is(ModTags.ModItemTags.COLORABLE)) {
            for (int i = 0; i < input.getContainerSize(); ++i) {
                ItemStack stack = input.getItem(i);
                int colorId = (Integer)stack.getOrDefault(ModDataComponents.COLOR_ID.get(), (Object)-1);
                int color = (Integer)stack.getOrDefault(ModDataComponents.COLOR.get(), (Object)-1);
                if (colorId == -1 || color == -1) continue;
                output.set(ModDataComponents.COLOR_ID, (Object)colorId);
                output.set(ModDataComponents.COLOR, (Object)color);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highPriorityClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof JarOfBonmeelItem) {
            JarOfBonmeelItem jarOfBonmeelItem = (JarOfBonmeelItem)item;
            InteractionResult interactionResult = jarOfBonmeelItem.highPriorityUseOn(new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec()));
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractRightClickItem(UseItemOnBlockEvent event) {
        BlockPatternCapability.PatternData data;
        BlockState state1;
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        ItemStack item = player.getItemInHand(hand).getItem().getDefaultInstance();
        if (event.isCanceled()) {
            return;
        }
        if ((item.is((Item)ModItems.REBREWED_POTION.get()) || item.is((Item)ModItems.EXTRACTED_BOTTLE.get())) && state.is(Blocks.DIRT)) {
            event.setCancellationResult(ItemInteractionResult.FAIL);
            event.setCanceled(true);
        }
        if (item.is(ItemTags.AXES) && (state.is((Block)ModBlocks.VIVICUS_LOG.get()) || state.is((Block)ModBlocks.VIVICUS_WOOD.get()))) {
            Block strippedBlock = (Block)AxeItem.STRIPPABLES.get(state.getBlock());
            state1 = (BlockState)((BlockState)strippedBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)))).setValue(ModStateProperties.COLOR, (Comparable)((DyeColor)state.getValue(ModStateProperties.COLOR)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, item);
            }
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, state1, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state1));
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if ((item.is((Item)ModItems.JAR_OF_BONMEEL.get()) || item.is((Item)ModItems.JAR_OF_ACID.get())) && state.is(Blocks.CAULDRON)) {
            Block cauldronType = item.is((Item)ModItems.JAR_OF_BONMEEL.get()) ? (Block)ModBlocks.BONMEEL_FILLED_CAULDRON.get() : (Block)ModBlocks.ACID_FILLED_CAULDRON.get();
            state1 = (BlockState)cauldronType.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            level.setBlock(pos, state1, 3);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            if (!player.isCreative()) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            }
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (BlockPatternCapability.hasPattern(pos, level) && itemStack.is(Items.GLOW_INK_SAC) && !(data = BlockPatternCapability.getPattern(pos, level)).isGlowing()) {
            BlockPatternCapability.enableGlowing(level, pos);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (itemStack.is(Items.FLINT_AND_STEEL) && state.is(Blocks.TORCHFLOWER)) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            player.setItemInHand(hand, itemStack);
            level.setBlock(pos, (BlockState)((Block)ModBlocks.TORCHFLOWER_AFLAME.get()).defaultBlockState().setValue((Property)ModStateProperties.AGE_2, (Comparable)Integer.valueOf(1)), 3);
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

