/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.gui.screen.DyespriaTooltip;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.DyespriaMode;
import net.abraxator.moresnifferflowers.components.EntityDistanceComparator;
import net.abraxator.moresnifferflowers.components.PatternspriaMode;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PatternspriaItem
extends Item {
    private final Map<BlockPos, BlockPatternCapability.PatternData> cached_patterns = new HashMap<BlockPos, BlockPatternCapability.PatternData>();
    public static final int DEFAULT_COLOR = 11113613;

    public PatternspriaItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPatternCapability.PatternData patternData;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        ItemStack stack = context.getItemInHand();
        Direction horizontalDirection = context.getHorizontalDirection();
        BlockPattern fromPatternspria = BlockPattern.fromPatternspria(stack);
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player.isCrouching() && BlockPatternCapability.hasPattern(blockPos, level)) {
            if (!stack.has(ModDataComponents.COLOR)) {
                stack.set(ModDataComponents.COLOR, (Object)-1);
            }
            if (((Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)11113613)).intValue() != BlockPatternCapability.getPattern(blockPos, level).color()) {
                this.copyColor(stack, level, blockPos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (blockState.is((Block)ModBlocks.PATTERNFLOWER.get()) && fromPatternspria != BlockPattern.EMPTY) {
            if (BlockPattern.fromState(blockState).equals((Object)fromPatternspria)) {
                return InteractionResult.PASS;
            }
            level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue(ModStateProperties.BLOCK_PATTERN, (Comparable)((Object)fromPatternspria))).setValue((Property)ModStateProperties.EMPTY, (Comparable)Boolean.valueOf(false)), 3);
            this.finishColoring(fromPatternspria.getItemStack(stack), level, stack, blockPos, context.getClickedFace());
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(blockPos, level, stack)) {
            int oldCount = (Integer)stack.getOrDefault(ModDataComponents.AMOUNT, (Object)0);
            AtomicInteger currentCount = new AtomicInteger(oldCount);
            AtomicBoolean canContinueDyeing = new AtomicBoolean(true);
            PatternspriaMode dyespriaMode = this.getMode(stack);
            PatternspriaMode.DyespriaSelector dyespriaSelector = new PatternspriaMode.DyespriaSelector(blockPos, level, context.getClickedFace());
            Set<BlockPos> set = dyespriaMode.getSelector().apply(dyespriaSelector);
            set.stream().sorted(new EntityDistanceComparator(blockPos)).takeWhile(t -> canContinueDyeing.get()).forEach(blockPos1 -> {
                BlockState state = level.getBlockState(blockPos1);
                if (this.canUse((BlockPos)blockPos1, level, stack) && fromPatternspria != BlockPattern.EMPTY) {
                    this.patternOne(stack, level, (BlockPos)blockPos1, fromPatternspria, context.getClickedFace(), horizontalDirection);
                    currentCount.getAndDecrement();
                } else if ((Integer)stack.getOrDefault(ModDataComponents.AMOUNT, (Object)0) <= 0 || fromPatternspria == BlockPattern.EMPTY) {
                    canContinueDyeing.set(false);
                }
                if (oldCount - currentCount.get() >= 64) {
                    canContinueDyeing.set(false);
                }
            });
            if (!level.isClientSide) {
                BlockPatternCapability.setBulkPatterns(this.cached_patterns, level);
                this.cached_patterns.clear();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockPattern pattern = fromPatternspria;
        if (BlockPatternCapability.hasPattern(blockPos, level) && pattern != BlockPattern.EMPTY && !(patternData = BlockPatternCapability.getPattern(blockPos, level)).direction().equals((Object)horizontalDirection) && pattern.getId() == patternData.patternId()) {
            BlockPatternCapability.setPattern(blockPos, new BlockPatternCapability.PatternData(patternData.patternId(), patternData.color(), horizontalDirection, patternData.isGlowing()), level);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public PatternspriaMode getMode(ItemStack stack) {
        return (PatternspriaMode)((Object)stack.getOrDefault(ModDataComponents.PATTERNSPRIA_MODE, (Object)PatternspriaMode.SINGLE));
    }

    public boolean patternOne(ItemStack stack, Level level, BlockPos blockPos, BlockPattern pattern, Direction face, Direction horizontalDirection) {
        if (!this.canUse(blockPos, level, stack) && pattern == BlockPattern.EMPTY) {
            return false;
        }
        int color = this.getColor(stack);
        if (BlockPatternCapability.hasPattern(blockPos, level)) {
            color = BlockPatternCapability.getPattern(blockPos, level).color();
        }
        if (!level.isClientSide) {
            this.cached_patterns.put(blockPos.immutable(), new BlockPatternCapability.PatternData(pattern.getId(), color, horizontalDirection, false));
        }
        this.finishColoring(pattern.getItemStack(stack), level, stack, blockPos, face);
        return true;
    }

    private boolean canUse(BlockPos pos, Level level, ItemStack patternspria) {
        if (BlockPattern.fromPatternspria(patternspria) == BlockPattern.EMPTY) {
            return false;
        }
        int groundId = -1;
        if (BlockPatternCapability.hasPattern(pos, level)) {
            groundId = BlockPatternCapability.getPattern(pos, level).patternId();
        }
        int inputId = BlockPattern.fromPatternspria(patternspria).getId();
        boolean isSturdy = false;
        for (Direction dir : Direction.values()) {
            if (!level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, dir)) continue;
            isSturdy = true;
            break;
        }
        return (!BlockPatternCapability.hasPattern(pos, level) || inputId != groundId) && (Integer)patternspria.getOrDefault(ModDataComponents.AMOUNT, (Object)0) > 0 && isSturdy;
    }

    public void finishColoring(ItemStack blockPattern, Level level, ItemStack patternspria, BlockPos blockPos, Direction face) {
        int uses = PatternspriaItem.getPatternspriaUses(patternspria) - 1;
        BlockPattern pattern = BlockPattern.fromItem(blockPattern.getItem());
        if (uses <= 0) {
            blockPattern.shrink(1);
            if (blockPattern.isEmpty()) {
                BlockPattern.removePatternFromStack(patternspria);
            } else {
                PatternspriaItem.setPatternspriaUses(patternspria, 4);
            }
        } else {
            PatternspriaItem.setPatternspriaUses(patternspria, uses);
        }
        BlockPattern.setPatternToHolderStack(patternspria, blockPattern, blockPattern.getCount(), PatternspriaItem.getPatternspriaUses(patternspria));
        if (level.isClientSide && pattern != BlockPattern.EMPTY) {
            this.spawnParticles(level.getRandom(), level, pattern, blockPos, face, patternspria);
        }
    }

    public ItemStack addPattern(ItemStack patternspria, ItemStack itemToInsert) {
        BlockPattern pattern = BlockPattern.fromItem(itemToInsert.getItem());
        BlockPattern patternInside = BlockPattern.fromPatternspria(patternspria);
        if (patternInside == BlockPattern.EMPTY) {
            BlockPattern.removePatternFromStack(patternspria);
        }
        if (pattern == BlockPattern.EMPTY) {
            return itemToInsert;
        }
        if (patternInside == BlockPattern.EMPTY || (Integer)patternspria.getOrDefault(ModDataComponents.AMOUNT, (Object)0) <= 0) {
            this.onAddPattern(patternspria, itemToInsert, itemToInsert.getCount());
            return ItemStack.EMPTY;
        }
        if (!pattern.isSamePattern(patternspria)) {
            ItemStack returnStack = patternInside.getItemStack(patternspria);
            this.onAddPattern(patternspria, itemToInsert, itemToInsert.getCount());
            return returnStack;
        }
        int amountInside = (Integer)patternspria.getOrDefault(ModDataComponents.AMOUNT, (Object)0);
        int freeSpace = 64 - amountInside;
        if (freeSpace <= 0) {
            return itemToInsert;
        }
        int amountToAdd = Math.min(itemToInsert.getCount(), freeSpace);
        this.onAddPattern(patternspria, itemToInsert, amountInside + amountToAdd);
        itemToInsert.shrink(amountToAdd);
        return itemToInsert;
    }

    public void onAddPattern(ItemStack destinationStack, ItemStack pattern, int amount) {
        destinationStack.remove(ModDataComponents.COLOR);
        int uses = PatternspriaItem.getPatternspriaUses(destinationStack);
        BlockPattern.setPatternToHolderStack(destinationStack, pattern, amount, uses <= 0 ? 4 : uses);
    }

    private ItemStack removePattern(ItemStack stack) {
        BlockPattern pattern = BlockPattern.fromPatternspria(stack);
        int uses = PatternspriaItem.getPatternspriaUses(stack);
        if (pattern != BlockPattern.EMPTY) {
            ItemStack returnStack = pattern.getItemStack(stack);
            BlockPattern.removePatternFromStack(stack);
            returnStack.shrink(uses == 4 ? 0 : 1);
            return returnStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            if (other.isEmpty()) {
                access.set(this.removePattern(stack));
                this.playRemoveOneSound((Entity)player);
            } else {
                ItemStack itemStack = this.addPattern(stack, other);
                access.set(itemStack);
                if (itemStack.isEmpty()) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    public void copyColor(ItemStack patternspria, Level level, BlockPos blockPos) {
        if (BlockPatternCapability.hasPattern(blockPos, level)) {
            BlockPatternCapability.PatternData patternData = BlockPatternCapability.getPattern(blockPos, level);
            patternspria.set(ModDataComponents.COLOR, (Object)patternData.color());
        }
    }

    public int getColor(ItemStack patternspria) {
        return (Integer)patternspria.getOrDefault(ModDataComponents.COLOR, (Object)11113613);
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    public int getBarColor(ItemStack stack) {
        int input = PatternspriaItem.getPatternspriaUses(stack);
        int maxInput = 4;
        int color = stack.has(ModDataComponents.COLOR) ? ((Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)11113613)).intValue() : BlockPattern.fromPatternspria(stack).getColor();
        return color;
    }

    public boolean isBarVisible(ItemStack stack) {
        return BlockPattern.fromPatternspria(stack) != BlockPattern.EMPTY;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)PatternspriaItem.getPatternspriaUses(stack) * 13.0f / 4.0f);
    }

    public static int getPatternspriaUses(ItemStack stack) {
        int uses = (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)4);
        if (uses > 4 || uses < 0) {
            MoreSnifferFlowers.LOGGER.warn("Invalid uses amount for patternspria: " + uses);
            stack.set(ModDataComponents.USES, (Object)4);
            return 4;
        }
        return uses;
    }

    public static void setPatternspriaUses(ItemStack stack, int uses) {
        if (uses > 4 || uses < 0) {
            MoreSnifferFlowers.LOGGER.warn("Tried setting invalid uses amount for patternspria: " + uses);
            stack.set(ModDataComponents.USES, (Object)4);
            return;
        }
        stack.set(ModDataComponents.USES, (Object)uses);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.dyespria.shift").withStyle(ChatFormatting.GOLD));
            return;
        }
        BlockPattern pattern = BlockPattern.fromPatternspria(stack);
        MutableComponent usage = Component.translatableWithFallback((String)"tooltip.patternspria.usage", (String)"Right click with dye to insert \nRight click caulorflower to repaint \nSneak to apply to the whole column \n").withStyle(ChatFormatting.GOLD);
        Stream<String> usageComponents = Arrays.stream(usage.getString().split("\n", -1)).filter(s -> !s.isEmpty()).map(String::trim);
        usageComponents.forEach(s -> tooltipComponents.add((Component)Component.literal((String)s).withStyle(ChatFormatting.GOLD)));
        tooltipComponents.add((Component)Component.empty());
        tooltipComponents.add(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(this.getMode(stack).ordinal())));
        tooltipComponents.add((Component)Component.empty());
        if (pattern != BlockPattern.EMPTY) {
            ItemStack patternStack = pattern.getItemStack(stack);
            MutableComponent name = Component.literal((String)(patternStack.getCount() + " - " + WordUtils.capitalizeFully((String)pattern.getSerializedName().toLowerCase().replaceAll("[^a-z_]", "").replaceAll("_", " ")))).withStyle(Style.EMPTY.withColor(pattern.getColor()));
            tooltipComponents.add((Component)name);
        } else {
            tooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.dyespria.empty", (String)"Empty").withStyle(ChatFormatting.GRAY));
        }
    }

    public void spawnParticles(RandomSource randomSource, Level level, BlockPattern pattern, BlockPos blockPos, Direction face, ItemStack stack) {
        Vector3f vector3f = blockPos.getCenter().toVector3f();
        if (face != null) {
            vector3f = vector3f.add((Vector3fc)face.step().div((Vector3fc)new Vector3f(2.0f, 2.0f, 2.0f)));
        }
        int color = (Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)pattern.getColor());
        for (int i = 0; i <= randomSource.nextIntBetweenInclusive(5, 10); ++i) {
            level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 1.0f), (double)vector3f.x + randomSource.nextDouble() - 0.5, (double)vector3f.y + randomSource.nextDouble() - 0.5, (double)vector3f.z + randomSource.nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void changeMode(ServerPlayer player, ItemStack stack, int amount) {
        PatternspriaMode currentMode = this.getMode(stack);
        PatternspriaMode newMode = PatternspriaMode.shift(currentMode, amount);
        stack.set(ModDataComponents.PATTERNSPRIA_MODE, (Object)newMode);
        player.displayClientMessage(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(newMode.ordinal())), true);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ItemStack pattern = BlockPattern.getItemStackFromPatternspria(stack);
        return Optional.of(new DyespriaTooltip(pattern, true, this.getMode(stack).ordinal()));
    }
}

