/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.lootmodifers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddItemsModifier
extends LootModifier {
    public static final MapCodec<AddItemsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> AddItemsModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ExtraCodecs.nonEmptyList((Codec)BuiltInRegistries.ITEM.byNameCodec().listOf()).fieldOf("item").forGetter(o -> o.items)).apply((Applicative)instance, AddItemsModifier::new));
    public static final List<ResourceLocation> SNIFFERENT_ITEMS_LOC = List.of(AddItemsModifier.snifferentLoc("spindlefern_seeds"), AddItemsModifier.snifferentLoc("spineflower_seeds"), AddItemsModifier.snifferentLoc("lumibulb_seeds"), AddItemsModifier.snifferentLoc("sniffberry_seedling"), AddItemsModifier.snifferentLoc("bloom_plant_nut"), AddItemsModifier.snifferentLoc("globar_sapling"), AddItemsModifier.snifferentLoc("club_moss_patch"), AddItemsModifier.snifferentLoc("amber"));
    public static final List<ResourceLocation> HELLIONS_ITEMS_LOC = List.of(AddItemsModifier.hellionsLoc("stone_pine_sapling"), AddItemsModifier.hellionsLoc("fiddlefern"), AddItemsModifier.hellionsLoc("ivy"));
    public static final List<ResourceLocation> QUARK_ITEMS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"ancient_sapling"));
    public static final List<ResourceLocation> ARTS_AND_CRAFTS_ITEMS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"arts_and_crafts", (String)"lotus_pistils"));
    public static final List<ResourceLocation> PEARFECTION_ITEMS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"pearfection", (String)"callery_twig"));
    public static final List<ResourceLocation> TRAIL_AND_TALES_DELIGHT_ITEMS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"trailandtales_delight", (String)"lantern_fruit_seeds"));
    public static final List<ResourceLocation> BOUNTIFUL_FARES_ITEMS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"bountifulfares", (String)"lapisberry_seeds"), ResourceLocation.fromNamespaceAndPath((String)"bountifulfares", (String)"hoary_seeds"));
    public static final List<ResourceLocation> ARKYS_AESTHETICS_LOC = List.of(ResourceLocation.fromNamespaceAndPath((String)"arky_aesthetics", (String)"moonflowers_vines"));
    private final List<Item> items;

    public AddItemsModifier(LootItemCondition[] conditionsIn, List<Item> items) {
        super(conditionsIn);
        this.items = items;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList newLoot = new ObjectArrayList();
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        generatedLoot.clear();
        generatedLoot.add((Object)Items.PITCHER_POD.getDefaultInstance());
        generatedLoot.add((Object)Items.TORCHFLOWER_SEEDS.getDefaultInstance());
        this.modSupport(SNIFFERENT_ITEMS_LOC, generatedLoot);
        this.modSupport(HELLIONS_ITEMS_LOC, generatedLoot);
        this.modSupport(QUARK_ITEMS_LOC, generatedLoot);
        this.modSupport(ARTS_AND_CRAFTS_ITEMS_LOC, generatedLoot);
        this.modSupport(PEARFECTION_ITEMS_LOC, generatedLoot);
        this.modSupport(TRAIL_AND_TALES_DELIGHT_ITEMS_LOC, generatedLoot);
        this.modSupport(BOUNTIFUL_FARES_ITEMS_LOC, generatedLoot);
        this.modSupport(ARKYS_AESTHETICS_LOC, generatedLoot);
        this.items.forEach(item -> generatedLoot.add((Object)item.getDefaultInstance()));
        newLoot.add((Object)((ItemStack)Util.getRandom(generatedLoot, (RandomSource)context.getRandom())));
        return newLoot;
    }

    private void modSupport(List<ResourceLocation> itemsLocList, ObjectArrayList<ItemStack> generatedLoot) {
        ArrayList itemList = new ArrayList();
        itemsLocList.forEach(resourceLocation -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
            if (!item.getDefaultInstance().is(Items.AIR)) {
                itemList.add(item.getDefaultInstance());
            }
        });
        if (itemList.isEmpty()) {
            return;
        }
        generatedLoot.addAll(itemList);
    }

    private static ResourceLocation snifferentLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"snifferent", (String)path);
    }

    private static ResourceLocation hellionsLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"snifferplus", (String)path);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

