/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.mixins;

import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FlowerBlock.class})
public abstract class FlowerBlockMixin
extends BushBlock
implements SuspiciousEffectHolder {
    public FlowerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.is(Blocks.TORCHFLOWER) || super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        boolean isWaterUnderneath = level.getFluidState(pos.below(2)).is(FluidTags.WATER);
        if (state.is(Blocks.TORCHFLOWER) && level.getBrightness(LightLayer.SKY, pos) > 13 && level.isDay() && !level.isRaining() && !isWaterUnderneath) {
            level.setBlock(pos, (BlockState)((BlockState)((Block)ModBlocks.TORCHFLOWER_AFLAME.get()).defaultBlockState().setValue((Property)ModStateProperties.AGE_2, (Comparable)Integer.valueOf(1))).setValue((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

