/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import io.netty.buffer.ByteBuf;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.networking.MSFClientPacket;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record CorruptedSludgePacket(Vector3f start, Vector3f target, Vector3f direction) implements MSFClientPacket
{
    public static final CustomPacketPayload.Type<CorruptedSludgePacket> TYPE = new CustomPacketPayload.Type(MoreSnifferFlowers.loc("send_sludge_particle"));
    public static final StreamCodec<ByteBuf, CorruptedSludgePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, CorruptedSludgePacket::start, (StreamCodec)ByteBufCodecs.VECTOR3F, CorruptedSludgePacket::target, (StreamCodec)ByteBufCodecs.VECTOR3F, CorruptedSludgePacket::direction, CorruptedSludgePacket::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientPacket(Player player, Level level) {
        float distance = this.start.distance((Vector3fc)this.target);
        for (int i = 0; i < 15; ++i) {
            double progress = (double)i / 15.0;
            Vector3f pos = new Vector3f((Vector3fc)this.start).add((Vector3fc)new Vector3f((Vector3fc)this.direction).mul((float)((double)distance * progress)));
            level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)4469320).toVector3f(), 1.0f), (double)pos.x, (double)pos.y, (double)pos.z, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

