/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toServer;

import io.netty.buffer.ByteBuf;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.abraxator.moresnifferflowers.networking.MSFServerPacket;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record DyespriaModePacket(int amount) implements MSFServerPacket
{
    public static final CustomPacketPayload.Type<DyespriaModePacket> TYPE = new CustomPacketPayload.Type(MoreSnifferFlowers.loc("dyespria_mode"));
    public static final StreamCodec<ByteBuf, DyespriaModePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DyespriaModePacket::amount, DyespriaModePacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handlePacket(Player player, Level level) {
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof DyespriaItem) {
            DyespriaItem dyespriaItem = (DyespriaItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                dyespriaItem.changeMode(serverPlayer, stack, this.amount);
            }
        }
    }
}

