/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.boblingtree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BoblingTreeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BoblingTreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(p_338099_ -> BoblingTreeTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)p_338099_).apply((Applicative)p_338099_, BoblingTreeTrunkPlacer::new));
    public static final BlockStateProvider BLACK_STONE = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.BLACKSTONE.defaultBlockState(), 100).add((Object)Blocks.GILDED_BLACKSTONE.defaultBlockState(), 60));
    public static final BlockStateProvider DEEPSLATE = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.DEEPSLATE.defaultBlockState(), 100).add((Object)Blocks.DEEPSLATE_IRON_ORE.defaultBlockState(), 80).add((Object)Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState(), 50).add((Object)Blocks.EMERALD_ORE.defaultBlockState(), 50));
    public static final BlockStateProvider STONE = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.STONE.defaultBlockState(), 100).add((Object)Blocks.COAL_ORE.defaultBlockState(), 80).add((Object)Blocks.GOLD_ORE.defaultBlockState(), 50).add((Object)Blocks.COPPER_ORE.defaultBlockState(), 50));

    public BoblingTreeTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.BOBLING_TREE_TRUNK.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int freeHeight, BlockPos startPos, TreeConfiguration treeConfiguration) {
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (int height = 0; height < freeHeight; ++height) {
            double chance = 0.6;
            List directions = Direction.Plane.HORIZONTAL.shuffledCopy(randomSource);
            do {
                chance -= 0.2;
                Direction direction = (Direction)directions.get(randomSource.nextInt(directions.size()));
                BlockPos pos = startPos.above(height);
                int h = randomSource.nextInt(4) + 1 - height / 2;
                Branch branch = new Branch(pos, direction, 0, height);
                branches.add(branch);
            } while (randomSource.nextDouble() < chance && !directions.isEmpty());
            for (int b = 0; b < branches.size(); ++b) {
                Branch newBranch;
                Branch branch = (Branch)branches.get(b);
                BlockPos.MutableBlockPos mutableBlockPos = branch.blockPos.mutable();
                int h = branch.height;
                this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.move(branch.direction), startPos);
                if (randomSource.nextDouble() < 0.66) {
                    this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.move(branch.direction), startPos);
                }
                if (branch.height < height) {
                    this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.move(Direction.UP), startPos);
                    ++h;
                }
                if ((newBranch = new Branch(mutableBlockPos.immutable(), branch.direction, h, branch.maxHeight)).equals(branch)) continue;
                branches.set(b, branch);
            }
            this.placeBlock(biConsumer, randomSource, startPos.above(height), startPos);
        }
        return List.of();
    }

    protected void placeBlock(BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, BlockPos startPos) {
        blockSetter.accept(pos, this.determineBlockVariation(startPos, pos, random));
    }

    public BlockState determineBlockVariation(BlockPos startPos, BlockPos blockPos, RandomSource random) {
        int dist = startPos.distManhattan((Vec3i)blockPos);
        if (dist > 5 && random.nextDouble() < 0.8) {
            return BLACK_STONE.getState(random, blockPos);
        }
        if (dist <= 5 && dist > 2 && random.nextDouble() < 0.8) {
            return DEEPSLATE.getState(random, blockPos);
        }
        return STONE.getState(random, blockPos);
    }

    protected boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return super.validTreePos(level, pos) || level.isStateAtPosition(pos, blockState -> blockState.is(ModTags.ModBlockTags.VIVICUS_TREE_REPLACABLE));
    }

    public record Branch(BlockPos blockPos, Direction direction, int height, int maxHeight) {
    }
}

