/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class GrowingCropBlockEntity
extends ModBlockEntity {
    public float growProgress;
    public boolean hasGrown;
    public final float growRate;

    public GrowingCropBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, float growRate) {
        super(type, pos, state);
        this.growRate = growRate;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    @Override
    public void tick(Level level) {
        if (this.canGrow(this.growProgress, this.hasGrown)) {
            this.growProgress += this.growRate;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            if (this.growProgress >= 1.0f) {
                this.onGrow(this.m_58899_(), this.m_58900_(), this.m_58904_());
            }
        }
    }

    public boolean canGrow(float growProgress, boolean hasGrown) {
        return !(growProgress >= 1.0f) && !hasGrown;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void onGrow(BlockPos blockPos, BlockState state, Level level) {
        this.hasGrown = true;
        this.f_58857_.m_7260_(blockPos, state, state, 2);
    }

    public void reset() {
        this.growProgress = 0.0f;
        this.hasGrown = false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hasGrown = tag.m_128471_("hasGrown");
        this.growProgress = tag.m_128457_("progress");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("hasGrown", this.hasGrown);
        tag.m_128350_("progress", this.growProgress);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

