/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.Optional;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface Corruptable {
    default public Optional<Block> getCorruptedBlock(Block block, Level level) {
        return CorruptionRecipe.getCorruptedBlock(block, level);
    }

    default public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockState corruptedState = corruptedBlock.m_152465_(oldState);
        level.m_46597_(pos, corruptedState);
    }

    default public void onCorruptByEntity(Entity entity, BlockPos blockPos, BlockState blockState, Block block, Level level) {
        if (entity instanceof CorruptedProjectile) {
            CorruptedProjectile corruptedProjectile = (CorruptedProjectile)entity;
            if (CorruptionRecipe.canBeCorrupted(block, level)) {
                this.onCorrupt(level, blockPos, blockState, this.getCorruptedBlock(block, level).get());
                corruptedProjectile.m_142687_(Entity.RemovalReason.DISCARDED);
                if (level.f_46443_) {
                    level.m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)3549245).m_252839_(), 1.0f), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

