/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DawnberryVineBlock
extends MultifaceBlock
implements BonemealableBlock,
ModCropBlock,
Corruptable {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static final BooleanProperty SHEARED = ModStateProperties.SHEARED;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);
    private final boolean evil;

    public DawnberryVineBlock(BlockBehaviour.Properties properties, boolean evil) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SHEARED, (Comparable)Boolean.FALSE));
        this.evil = evil;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE, SHEARED});
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    @Override
    public int getMaxAge() {
        return (Integer)AGE.m_6908_().stream().toList().get(AGE.m_6908_().size() - 1);
    }

    @Override
    public final boolean isMaxAge(BlockState state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state) && (Boolean)state.m_61143_((Property)SHEARED) == false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state) && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (this.isMaxAge(state)) {
            return this.dropMaxAgeLoot(state, level, pos, player);
        }
        if ((Integer)state.m_61143_((Property)AGE) == 3) {
            return this.dropAgeThreeLoot(state, level, pos, player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult dropMaxAgeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        RandomSource randomSource = level.m_213780_();
        ItemStack DAWNBERRY = new ItemStack(this.evil ? (ItemLike)ModItems.GLOOMBERRY.get() : (ItemLike)ModItems.DAWNBERRY.get(), randomSource.m_216332_(1, 2));
        DawnberryVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        BlockState state = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2));
        level.m_7731_(pos, state, 2);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected InteractionResult dropAgeThreeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        RandomSource randomSource = level.m_213780_();
        ItemStack DAWNBERRY = new ItemStack(this.evil ? (ItemLike)ModItems.GLOOMBERRY.get() : (ItemLike)ModItems.DAWNBERRY.get(), randomSource.m_216332_(1, 2));
        DawnberryVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        BlockState state = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2));
        level.m_7731_(pos, state, 2);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.onCorruptByEntity(entity, pos, state, (Block)this, level);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9) {
            this.makeGrowOnTick(state, (Level)level, pos);
        }
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age >= 4 ? age : age + 1)), 2);
        boolean canSpread = Direction.m_235666_().anyMatch(p_153316_ -> this.spreader.m_221601_(state, (BlockGetter)level, pos, p_153316_.m_122424_()));
        if (random.m_188501_() >= 0.3f && random.m_188501_() >= 0.3f && canSpread) {
            this.m_213612_().m_221619_(state, (LevelAccessor)level, pos, random);
            this.m_213612_().m_221619_(state, (LevelAccessor)level, pos, random);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean isEvil() {
        return this.evil;
    }
}

