/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blockentities.TorchflowerBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TorchflowerAflameBlock
extends BushBlock
implements ModEntityBlock,
ModCropBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public TorchflowerAflameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getAgeProperty()}).m_61104_(new Property[]{ModStateProperties.FIRE_TICKS});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.m_6810_(state, level, pos, newState, movedByPiston);
        if (this.getAge(state) == this.getMaxAge()) {
            TorchflowerAflameBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)((Item)ModItems.FIERY_SPICE.get()).m_7968_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            return;
        }
        super.m_214162_(state, level, pos, random);
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        Vec3 offset = new Vec3((double)pos.m_123341_() + vec3.f_82479_, (double)pos.m_123342_() + vec3.f_82480_, (double)pos.m_123343_() + vec3.f_82481_);
        Vec3 center = pos.m_252807_().m_82549_(vec3);
        if (this.getAge(state) == 1) {
            if (random.m_188503_(24) == 0) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int j1 = 0; j1 < 2; ++j1) {
                if (!(random.m_188501_() < 0.6f)) continue;
                double d7 = offset.f_82479_ + random.m_188500_();
                double d12 = offset.f_82480_ + 1.0 - random.m_188500_() * (double)0.1f;
                double d17 = offset.f_82481_ + random.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d7, d12, d17, 0.0, 0.0, 0.0);
            }
            if (random.m_188501_() < 0.3f) {
                double d1 = center.f_82479_ + random.m_188500_() / 3.0;
                double d2 = center.f_82480_ + 0.7 - random.m_188500_() / 2.0;
                double d3 = center.f_82481_ + random.m_188500_() / 3.0;
                Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.TORCHFLAME.get(), d1, d2, d3, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.m_6569_(0.5f + random.m_188501_());
                }
            }
        }
    }

    public boolean m_6724_(BlockState state) {
        int age = this.getAge(state);
        return age == 0 || age == 1;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = this.getAge(state);
        if (age == 0) {
            this.makeGrowOnTick(state, (Level)level, pos);
        }
        if (age == 1 && (!level.m_8055_(pos.m_6625_(2)).m_60713_(Blocks.f_50134_) || level.m_46758_(pos))) {
            int fire = (Integer)state.m_61143_((Property)ModStateProperties.FIRE_TICKS);
            if (fire < 5 && !level.m_46758_(pos)) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(fire + 1)));
            } else {
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(2)));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        int age = this.getAge(state);
        int fire = (Integer)state.m_61143_((Property)ModStateProperties.FIRE_TICKS);
        if (age == 0 && stack.m_150930_(Items.f_42499_)) {
            if (TorchflowerAflameBlock.isBonemealSuccess(level)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.m_214148_(serverLevel, level.f_46441_, pos, state);
                }
            } else if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            BoneMealItem.m_40638_((LevelAccessor)level, (BlockPos)pos, (int)10);
            return InteractionResult.SUCCESS;
        }
        if (age == 1 && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
            RandomSource random = level.m_213780_();
            for (int j1 = 0; j1 < (fire + 1) * 2; ++j1) {
                Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
                Vec3 center = pos.m_252807_().m_82549_(vec3);
                double d7 = center.f_82479_ + random.m_188500_() - 0.5;
                double d12 = center.f_82480_ - random.m_188500_() + 0.5;
                double d17 = center.f_82481_ + random.m_188500_() - 0.5;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 2.0f), d7, d12, d17, 0.0, 0.0, 0.0);
            }
            if (!player.m_7500_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            }
            if (fire < 5) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(fire + 1)));
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
            } else {
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(2)));
            }
            return InteractionResult.SUCCESS;
        }
        if (age == 2) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean isBonemealSuccess(Level level) {
        return level.f_46441_.m_188501_() < 0.3f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TorchflowerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> pBlockEntityType) {
        return this.tickerHelper(level);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(level, pos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.getAge(state) == 0;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return TorchflowerAflameBlock.isBonemealSuccess(level);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_46597_(pos, Blocks.f_271329_.m_49966_());
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }
}

